/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.controller.EsdcExportController;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcCrosslineEventRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineEventService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineEventItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcCrosslineEventController
extends EsdcExportController
implements EsdcCrosslineEventRemote {
    @Autowired
    private EsdcCrosslineEventService esdcCrosslineEventService;

    public ModelAndView index() {
        return new ModelAndView("esdc/crosslineEvent/crosslineEvent");
    }

    @RequiresPermissions(value={"esdc:crosslineEvent:refresh"})
    public DxGrid list(EsdcCrosslineEventItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.esdcCrosslineEventService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    public ZKResultMsg getCrosslineMapsData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcCrosslineEventService.getCrosslineMapsData());
    }

    @RequiresPermissions(value={"esdc:crosslineEvent:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EsdcCrosslineEventItem esdcCrosslineEventItem = new EsdcCrosslineEventItem();
        this.setConditionValue((BaseItem)esdcCrosslineEventItem);
        List itemList = this.esdcCrosslineEventService.getItemData(EsdcCrosslineEventItem.class, (BaseItem)esdcCrosslineEventItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EsdcCrosslineEventItem.class);
    }

    public ZKResultMsg getCrosslineTrend(String time, String areaId) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.esdcCrosslineEventService.getCrosslineTrend(time, areaId));
    }
}

