/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcCrosslineRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineAreaService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcLicenseCheckService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineAreaItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineCalculationItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcCrosslineController
extends BaseController
implements EsdcCrosslineRemote {
    @Autowired
    private EsdcCrosslineService esdcCrosslineService;
    @Autowired
    private EsdcCrosslineAreaService esdcCrosslineAreaService;
    @Autowired
    private EsdcLicenseCheckService esdcLicenseCheckService;

    @RequiresPermissions(value={"esdc:crossline"})
    public ModelAndView index() {
        Boolean peopleCounting = this.esdcLicenseCheckService.checkByModuleCode("peoplecounting");
        if (peopleCounting == null || !peopleCounting.booleanValue()) {
            return new ModelAndView("esdc/license/licenseCheck");
        }
        Cookie[] cookies = this.request.getCookies();
        String areaId = null;
        for (Cookie cookie : cookies) {
            if (cookie.getName() == null || !cookie.getName().equals("areaId")) continue;
            areaId = cookie.getValue();
        }
        List areaItemList = this.esdcCrosslineAreaService.getByCondition(new EsdcCrosslineAreaItem());
        EsdcCrosslineCalculationItem calculate = new EsdcCrosslineCalculationItem();
        EsdcCrosslineAreaItem authAreaItem = this.esdcCrosslineAreaService.getItemById(areaId);
        int count = 0;
        if (Objects.nonNull(authAreaItem)) {
            authAreaItem = Optional.ofNullable(this.esdcCrosslineAreaService.getItemById(areaId)).orElse(new EsdcCrosslineAreaItem());
            calculate = this.esdcCrosslineService.calculateByAreaId(areaId);
            count = calculate.getCapacity() - calculate.getTotalIn() + calculate.getTotalOut() - Optional.ofNullable(authAreaItem.getCheckPersonCount()).orElse(0);
        } else if (!CollectionUtils.isEmpty((Collection)areaItemList)) {
            authAreaItem = (EsdcCrosslineAreaItem)areaItemList.get(0);
            calculate = this.esdcCrosslineService.calculateByAreaId(authAreaItem.getId());
            count = calculate.getCapacity() - calculate.getTotalIn() + calculate.getTotalOut() - Optional.ofNullable(authAreaItem.getCheckPersonCount()).orElse(0);
        }
        if (count > Integer.valueOf(calculate.getCapacity())) {
            count = calculate.getCapacity();
        }
        this.request.setAttribute("count", (Object)count);
        this.request.setAttribute("item", (Object)calculate);
        this.request.setAttribute("areaItem", (Object)authAreaItem);
        return new ModelAndView("esdc/crossline/esdcCrosslineCensus");
    }

    public String setIntervalOverTime() {
        return "OK";
    }

    public ZKResultMsg clearImme(String authAreaId) {
        boolean b = this.esdcCrosslineService.clearCrosslineImme(authAreaId);
        return new ZKResultMsg((Object)b);
    }
}

