/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcCrosslineConfigImgRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineConfigImgService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineConfigImgItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcCrosslineConfigImgController
extends BaseController
implements EsdcCrosslineConfigImgRemote {
    @Autowired
    private EsdcCrosslineConfigImgService esdcCrosslineConfigImgService;

    @RequiresPermissions(value={"esdc:crosslineConfigImg"})
    public ModelAndView index() {
        return new ModelAndView("esdc/crossline/esdcCrosslineConfigImgList");
    }

    @RequiresPermissions(value={"esdc:crosslineConfigImg:refresh"})
    public DxGrid list(EsdcCrosslineConfigImgItem condition) {
        Pager pager = this.esdcCrosslineConfigImgService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"esdc:crosslineConfigImg:add"})
    public ModelAndView edit() {
        List itemList = this.esdcCrosslineConfigImgService.getByCondition(new EsdcCrosslineConfigImgItem());
        this.request.setAttribute("imageCount", (Object)itemList.size());
        return new ModelAndView("esdc/crossline/editCrosslineImgUpload");
    }

    @RequiresPermissions(value={"esdc:crosslineConfigImg:del"})
    public ZKResultMsg delete(String id) {
        ZKResultMsg msg = this.esdcCrosslineConfigImgService.deleteById(id);
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public ZKResultMsg saveCrosslineImage(String imageBase64, String imageSuffix) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcCrosslineConfigImgService.saveCrosslineImage(imageBase64, imageSuffix);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg selectCurrentImg(String imageId, String imageContent, String imageSrc) {
        return this.esdcCrosslineConfigImgService.selectCurrentImg(imageId, imageContent, imageSrc);
    }

    public ZKResultMsg getCrosslineConfigImage() {
        ZKResultMsg res = new ZKResultMsg();
        List selectCacheConfigImage = this.esdcCrosslineConfigImgService.getSelectCacheConfigImage();
        res.setData((Object)selectCacheConfigImage);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

