/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcCrosslineAreaRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineAreaService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcLicenseCheckService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineAreaItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcCrosslineAreaController
extends BaseController
implements EsdcCrosslineAreaRemote {
    @Autowired
    private EsdcCrosslineAreaService esdcCrosslineAreaService;
    @Autowired
    private EsdcCrosslineService esdcCrosslineService;
    @Autowired
    private EsdcLicenseCheckService esdcLicenseCheckService;

    @RequiresPermissions(value={"esdc:crosslineArea"})
    public ModelAndView index() {
        Boolean offDuty = this.esdcLicenseCheckService.checkByModuleCode("offduty");
        if (offDuty == null || !offDuty.booleanValue()) {
            return new ModelAndView("esdc/license/licenseCheck");
        }
        return new ModelAndView("esdc/crosslineArea/esdcCrosslineArea");
    }

    @RequiresPermissions(value={"esdc:crosslineArea:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcCrosslineAreaService.getItemById(id));
        }
        return new ModelAndView("esdc/crosslineArea/editEsdcCrosslineArea");
    }

    @RequiresPermissions(value={"esdc:crosslineArea:check"})
    public ModelAndView checkPerson(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcCrosslineAreaService.getItemById(id));
        }
        return new ModelAndView("esdc/crosslineArea/editCheckPersonCount");
    }

    @RequiresPermissions(value={"esdc:crosslineArea:edit"})
    public ZKResultMsg save(EsdcCrosslineAreaItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcCrosslineAreaService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:crosslineArea:refresh"})
    public DxGrid list(EsdcCrosslineAreaItem condition) {
        Pager pager = this.esdcCrosslineAreaService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg findAllAreaName() {
        List crosslineAreaList = this.esdcCrosslineAreaService.findAllAreaName();
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"esdc_all", (Object[])new Object[0]), "");
        selectItems.add(selectItem);
        for (String crosslineArea : crosslineAreaList) {
            selectItem = new SelectItem();
            selectItem.setValue(crosslineArea);
            selectItem.setText((Object)crosslineArea);
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    @RequiresPermissions(value={"esdc:crosslineArea:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcCrosslineAreaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public String isExist(String areaId) {
        return String.valueOf(this.esdcCrosslineAreaService.getItemByAreaId(areaId) == null);
    }

    public TreeItem getCrosslineAreaTree() {
        Pager pager = this.esdcCrosslineAreaService.getItemsByPage((BaseItem)new EsdcCrosslineAreaItem(), this.getPageNo(), this.getPageSize());
        List esdcCrosslineAreaItemList = pager.getData();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (EsdcCrosslineAreaItem esdcCrosslineAreaItem : esdcCrosslineAreaItemList) {
            item = new TreeItem();
            item.setId(esdcCrosslineAreaItem.getId());
            item.setText(esdcCrosslineAreaItem.getName());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getItemById(String id) {
        EsdcCrosslineAreaItem item = this.esdcCrosslineAreaService.getItemById(id);
        return new ZKResultMsg((Object)item);
    }

    public ZKResultMsg editCheckPersonCount(EsdcCrosslineAreaItem item) {
        boolean result = this.esdcCrosslineService.clearCrosslineImme(item.getId());
        if (!result) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"esdc_crossline_select_area", (Object[])new Object[0]));
        }
        EsdcCrosslineAreaItem area = this.esdcCrosslineAreaService.getItemById(item.getId());
        area.setCheckPersonCount(item.getCheckPersonCount());
        this.esdcCrosslineAreaService.saveItem(area);
        return new ZKResultMsg();
    }
}

