/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.acc.service.Acc4OtherGetAccDoorService;
import com.zkteco.zkbiosecurity.acc.vo.Acc4OtherSelectDoorItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcBindingDeviceRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcBindingDeviceService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcBindingDeviceItem;
import com.zkteco.zkbiosecurity.psg.service.Psg4OtherGetReaderService;
import com.zkteco.zkbiosecurity.psg.vo.PsgReader4OtherItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;

@Controller
public class EsdcBindingDeviceController
extends BaseController
implements EsdcBindingDeviceRemote {
    @Autowired
    private EsdcBindingDeviceService esdcBindingDeviceService;
    @Autowired(required=false)
    private Acc4OtherGetAccDoorService acc4OtherGetAccDoorService;
    @Autowired(required=false)
    private Psg4OtherGetReaderService psg4OtherGetReaderService;

    @Deprecated
    @RequiresPermissions(value={"esdc:linkageacc:getEsdcLinkAccList"})
    public Map getEsdcLinkAccList() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List esdcBindingDeviceItems = this.esdcBindingDeviceService.findAllDoorItem();
        if (esdcBindingDeviceItems.size() > 0) {
            for (EsdcBindingDeviceItem item : esdcBindingDeviceItems) {
                String outputId = item.getDeviceId();
                if (!StringUtils.isNotBlank((CharSequence)outputId)) continue;
                Acc4OtherSelectDoorItem accDoor = this.acc4OtherGetAccDoorService.getItemById(outputId);
                if (outputId == null) continue;
                map.put(accDoor.getId(), accDoor.getName());
            }
            return map;
        }
        return null;
    }

    @RequiresPermissions(value={"esdc:quitJobPerson"})
    public ZKResultMsg getPassbackBindingDeviceList() {
        String sessionId = this.request.getSession().getId();
        List bindingDeviceList = this.esdcBindingDeviceService.getPassbackBindingDeviceNoModuleRepeatList(sessionId);
        if (!CollectionUtils.isEmpty((Collection)bindingDeviceList)) {
            for (EsdcBindingDeviceItem bindingDeviceItem : bindingDeviceList) {
                this.populateInformation(bindingDeviceItem);
            }
        }
        return new ZKResultMsg((Object)bindingDeviceList);
    }

    private void populateInformation(EsdcBindingDeviceItem bindingDeviceItem) {
        if (Objects.nonNull(this.acc4OtherGetAccDoorService) && "acc".equals(bindingDeviceItem.getSourceModule())) {
            Acc4OtherSelectDoorItem doorItem = this.acc4OtherGetAccDoorService.getItemById(bindingDeviceItem.getDeviceId());
            bindingDeviceItem.setDeviceAlias(doorItem.getName());
            bindingDeviceItem.setDeviceSn(doorItem.getDeviceSn());
        }
        if (Objects.nonNull(this.psg4OtherGetReaderService) && "psg".equals(bindingDeviceItem.getSourceModule())) {
            PsgReader4OtherItem psgReaderItem = this.psg4OtherGetReaderService.getItemById(bindingDeviceItem.getDeviceId());
            bindingDeviceItem.setDeviceAlias(psgReaderItem.getName());
        }
    }
}

