/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcAiBoxFaceLibSyncRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAiBoxDeviceService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAiBoxServiceStrategy;
import com.zkteco.zkbiosecurity.esdc.service.EsdcDevice2ListService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcDevice2PersonService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcPersonnelListService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDevice2ListItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDevice2PersonItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersonSelectItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcPersonnelListSelectItem;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EsdcAiBoxFaceLibSyncController
extends BaseController
implements EsdcAiBoxFaceLibSyncRemote {
    @Autowired(required=false)
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private EsdcAiBoxDeviceService esdcAiBoxDeviceService;
    @Autowired
    private EsdcDevice2ListService esdcDevice2ListService;
    @Autowired
    private EsdcDevice2PersonService esdcDevice2PersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private EsdcAiBoxServiceStrategy esdcAiBoxServiceStrategy;
    @Autowired
    private EsdcPersonnelListService esdcPersonnelListService;

    public DxGrid selectPersonnelList(EsdcPersonnelListSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(condition.getDeviceId());
            if (Objects.isNull(deviceItem)) {
                throw new ZKBusinessException();
            }
            boolean status = this.esdcPersonnelListService.checkAddPersonnelListStatus(condition.getDeviceId());
            if (!status) {
                pager = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).getPersonnelList(condition, this.getPageNo(), this.getPageSize(), false);
            } else {
                pager.setData(new ArrayList());
            }
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg addPersonnelList(String deviceId, String personnelListIds) {
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
        if (Objects.isNull(deviceItem)) {
            return ZKResultMsg.failMsg();
        }
        return this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).addPersonnelList(deviceId, personnelListIds, true);
    }

    public DxGrid personnelList(EsdcDevice2ListItem condition) {
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(condition.getDeviceId());
        if (Objects.isNull(deviceItem)) {
            throw new ZKBusinessException();
        }
        Pager pager = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).personnelList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getPersonList(EsdcDevice2PersonItem condition) {
        String sessionId = this.request.getSession().getId();
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(condition.getDeviceId());
        if (Objects.isNull(deviceItem)) {
            throw new ZKBusinessException();
        }
        Pager pager = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).getPersonPager(sessionId, condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            JSONArray status = JSON.parseArray((String)row.getString("data"));
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(status.get(3)) && Objects.nonNull(status.get(4))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    public ZKResultMsg delPersonnelList(String deviceId, String ids) {
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
        if (Objects.isNull(deviceItem)) {
            return ZKResultMsg.failMsg();
        }
        return this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).delPersonnelList(deviceId, ids);
    }

    public ZKResultMsg delPerson(String deviceId, String listId, String ids) {
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
        if (Objects.isNull(deviceItem)) {
            return ZKResultMsg.failMsg();
        }
        return this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).delPerson(deviceId, listId, ids);
    }

    public ZKResultMsg reSyncPersonnelList(String deviceId, String listIds) {
        EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
        if (Objects.isNull(deviceItem)) {
            return ZKResultMsg.failMsg();
        }
        return this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).reSyncPersonnelList(deviceId, listIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg reAddAiBoxPersons(String deviceId, String listId, String ids) {
        try {
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            if (StringUtils.isBlank((CharSequence)listId) || StringUtils.isBlank((CharSequence)ids)) {
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                return zKResultMsg;
            }
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                EsdcDeviceItem esdcAiBoxDeviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
                if (Objects.isNull(esdcAiBoxDeviceItem)) {
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                    ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                    return zKResultMsg;
                }
                EsdcDevice2ListItem esdcDevice2ListItem = this.esdcDevice2ListService.getItemById(listId);
                List esdcDevice2PersonItems = this.esdcDevice2PersonService.getItemByIds(ids);
                String personIds = esdcDevice2PersonItems.stream().map(EsdcDevice2PersonItem::getPersonId).collect(Collectors.joining(","));
                this.progressCache.setProcess(new ProcessBean(0, 50), clientId);
                ZKResultMsg resultMsg = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(esdcAiBoxDeviceItem.getVendor()).sendPersonToDev(deviceId, esdcDevice2ListItem.getPersonnelListId(), personIds, true, true);
                if (Objects.nonNull(resultMsg.getData()) && StringUtils.isNotEmpty((CharSequence)resultMsg.getData().toString())) {
                    this.progressCache.setProcess(new ProcessBean(0, 90, "<font color='red'>" + resultMsg.getData().toString() + "</font><br/>"));
                } else {
                    this.progressCache.setProcess(new ProcessBean(0, 90), clientId);
                }
            }
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return ZKResultMsg.successMsg();
    }

    public DxGrid selectPerson(EsdcPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            if (StringUtils.isNotBlank((CharSequence)condition.getDevPersonnelListId())) {
                EsdcDevice2ListItem esdcDevice2ListItem = this.esdcDevice2ListService.getItemById(condition.getDevPersonnelListId());
                condition.setDevPersonnelListId(esdcDevice2ListItem.getPersonnelListId());
                EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(condition.getDeviceId());
                if (Objects.isNull(deviceItem)) {
                    throw new ZKBusinessException();
                }
                pager = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(deviceItem.getVendor()).getNoExistPerson(condition, this.getPageNo(), this.getPageSize());
            }
        } else if ("selected".equals(condition.getType())) {
            pager.setData((List)Lists.newArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg addPerson(String deviceId, String devPersonnelListId, String personIds) {
        try {
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            if (StringUtils.isBlank((CharSequence)devPersonnelListId) || StringUtils.isBlank((CharSequence)personIds)) {
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                return zKResultMsg;
            }
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                EsdcDeviceItem esdcAiBoxDeviceItem = this.esdcAiBoxDeviceService.getItemById(deviceId);
                if (Objects.isNull(esdcAiBoxDeviceItem)) {
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                    ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                    return zKResultMsg;
                }
                this.progressCache.setProcess(new ProcessBean(0, 50), clientId);
                EsdcDevice2ListItem esdcDevice2ListItem = this.esdcDevice2ListService.getItemById(devPersonnelListId);
                ZKResultMsg resultMsg = this.esdcAiBoxServiceStrategy.getFaceLibSyncService(esdcAiBoxDeviceItem.getVendor()).sendPersonToDev(deviceId, esdcDevice2ListItem.getPersonnelListId(), personIds, true, true);
                if (Objects.nonNull(resultMsg.getData()) && StringUtils.isNotEmpty((CharSequence)resultMsg.getData().toString())) {
                    this.progressCache.setProcess(new ProcessBean(0, 90, "<font color='red'>" + resultMsg.getData().toString() + "</font><br/>"));
                } else {
                    this.progressCache.setProcess(new ProcessBean(0, 90), clientId);
                }
            }
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return ZKResultMsg.successMsg();
    }
}

