/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcAiBoxDeviceRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAiBoxDeviceService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.aiBox.EsdcAiBoxHttpReportConfigItem;
import com.zkteco.zkbiosecurity.esdc.vo.aiBox.EsdcAiBoxWsReportConfigItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcAiBoxDeviceController
extends BaseController
implements EsdcAiBoxDeviceRemote {
    @Autowired
    private EsdcAiBoxDeviceService esdcAiBoxDeviceService;

    @RequiresPermissions(value={"esdc:aiboxdevice"})
    public ModelAndView index() {
        return new ModelAndView("esdc/aiboxdevice/esdcAiBoxDevice");
    }

    @RequiresPermissions(value={"esdc:aiboxdevice:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcAiBoxDeviceService.getItemById(id));
        }
        return new ModelAndView("esdc/aiboxdevice/editEsdcAiBoxDevice");
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_op_edit", requestParams={"deviceName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"esdc:aiboxdevice:edit"})
    public ZKResultMsg save(EsdcDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcAiBoxDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:aiboxdevice:refresh"})
    public DxGrid list(EsdcDeviceItem codition) {
        Pager pager = this.esdcAiBoxDeviceService.pagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_op_del", requestParams={"ids"}, opContent="esdc_device_id")
    @RequiresPermissions(value={"esdc:aiboxdevice:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcAiBoxDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_op_reboot", requestParams={"ids"}, opContent="esdc_device_id")
    @RequiresPermissions(value={"esdc:aiboxdevice:reboot"})
    public ZKResultMsg reboot(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String offLine = "";
            List deviceItemList = this.esdcAiBoxDeviceService.getItemByIds(ids);
            for (EsdcDeviceItem deviceItem : deviceItemList) {
                if ("1".equals(deviceItem.getStatus())) continue;
                offLine = offLine + deviceItem.getDeviceName() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "<br/>";
            }
            if (StringUtils.isNotBlank((CharSequence)offLine)) {
                throw new ZKBusinessException(offLine);
            }
            retMsg = this.esdcAiBoxDeviceService.rebootByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getAiBoxDeviceTypeList() {
        return this.esdcAiBoxDeviceService.getAiBoxDeviceTypeList();
    }

    @RequiresPermissions(value={"esdc:aiboxdevice:setWebSocketConfig"})
    public ModelAndView getWebSocketConfig(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("deviceId", (Object)id);
            this.request.setAttribute("item", (Object)this.esdcAiBoxDeviceService.getWebSocketConfigById(id));
        }
        return new ModelAndView("esdc/aiboxdevice/editEsdcAiBoxWebSocketConfig");
    }

    public ZKResultMsg saveWebSocketConfig(EsdcAiBoxWsReportConfigItem item, @RequestParam(required=false) String deviceId) {
        return this.esdcAiBoxDeviceService.saveWebSocketConfig(item, deviceId);
    }

    @RequiresPermissions(value={"esdc:aiboxdevice:setHttpReportConfig"})
    public ModelAndView getHttpReportConfig(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String requestHead = String.valueOf(this.request.getRequestURL()).split("://")[0];
            this.request.setAttribute("requestHead", (Object)requestHead);
            this.request.setAttribute("deviceId", (Object)id);
            this.request.setAttribute("item", (Object)this.esdcAiBoxDeviceService.getHttpReportConfigById(id));
        }
        return new ModelAndView("esdc/aiboxdevice/editEsdcAiBoxHttpReportConfig");
    }

    public ZKResultMsg setHttpReportConfig(EsdcAiBoxHttpReportConfigItem item, String deviceId) {
        return this.esdcAiBoxDeviceService.setHttpReportConfig(item, deviceId);
    }

    public ZKResultMsg getAiBoxDeviceList() {
        List esdcAiBoxDeviceItems = this.esdcAiBoxDeviceService.getByCondition(new EsdcDeviceItem());
        ArrayList selectItemList = new ArrayList();
        esdcAiBoxDeviceItems.forEach(item -> {
            SelectItem selectItem = new SelectItem((Object)item.getDeviceName(), item.getId());
            selectItemList.add(selectItem);
        });
        return new ZKResultMsg(selectItemList);
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_dev_syncTime", requestParams={"names"}, opContent="common_dev_syncTime")
    @RequiresPermissions(value={"esdc:aiboxdevice:syncTime"})
    public ZKResultMsg syncTime(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String offline = "";
            List deviceItemList = this.esdcAiBoxDeviceService.getItemByIds(ids);
            for (EsdcDeviceItem deviceItem : deviceItemList) {
                if ("1".equals(deviceItem.getStatus())) continue;
                offline = offline + deviceItem.getDeviceName() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "<br/>";
            }
            if (StringUtils.isNotBlank((CharSequence)offline)) {
                throw new ZKBusinessException(offline);
            }
            retMsg = this.esdcAiBoxDeviceService.syncTime(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="esdc_ai_box_sync", requestParams={"names"}, opContent="esdc_ai_box_sync")
    @RequiresPermissions(value={"esdc:aiboxdevice:synchronize"})
    public ZKResultMsg syncAiChannel(String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String offLine = "";
            List deviceItemList = this.esdcAiBoxDeviceService.getItemByIds(ids);
            for (EsdcDeviceItem deviceItem : deviceItemList) {
                if ("1".equals(deviceItem.getStatus())) continue;
                offLine = offLine + deviceItem.getDeviceName() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "<br/>";
            }
            if (StringUtils.isNotBlank((CharSequence)offLine)) {
                throw new ZKBusinessException(offLine);
            }
            zkResultMsg = this.esdcAiBoxDeviceService.syncAiChannel(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg videoStorage(String channelId, String parentId) {
        String sessionId = this.request.getSession().toString();
        return this.esdcAiBoxDeviceService.videoStorage(channelId, parentId, sessionId);
    }

    @RequiresPermissions(value={"esdc:aiboxdevice:delAllDeviceFace"})
    public ZKResultMsg delAllDeviceFace(String deviceId) {
        return this.esdcAiBoxDeviceService.delAllDeviceFace(deviceId);
    }
}

