/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.controller;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.esdc.constant.EsdcConstants;
import com.zkteco.zkbiosecurity.esdc.remote.EsdcAiBoxChannelRemote;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAiBoxChannelService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcAiBoxDeviceService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcChannelItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDeviceItem;
import com.zkteco.zkbiosecurity.esdc.vo.aiBox.EsdcAiBoxChannelAlertRulesConfigItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EsdcAiBoxChannelController
extends BaseController
implements EsdcAiBoxChannelRemote {
    @Autowired
    private EsdcAiBoxChannelService esdcAiBoxChannelService;
    @Autowired
    private EsdcAiBoxDeviceService esdcAiBoxDeviceService;

    @RequiresPermissions(value={"esdc:aiboxchannel"})
    public ModelAndView index() {
        return new ModelAndView("esdc/aiboxchannel/esdcAiBoxChannel");
    }

    @RequiresPermissions(value={"esdc:aiboxchannel:edit"})
    public ModelAndView edit(String deviceId, String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.esdcAiBoxChannelService.getItemById(id));
        } else if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            EsdcChannelItem channelItem = new EsdcChannelItem();
            channelItem.setDeviceId(deviceId);
            this.request.setAttribute("item", (Object)channelItem);
        }
        return new ModelAndView("esdc/aiboxdevice/editEsdcAiBoxChannel");
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_op_edit", requestParams={"name"}, opContent="common_dev_channelName")
    @RequiresPermissions(value={"esdc:aiboxchannel:edit"})
    public ZKResultMsg save(EsdcChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.esdcAiBoxChannelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"esdc:aiboxchannel:refresh"})
    public DxGrid list(EsdcChannelItem condition) {
        Pager pager = this.esdcAiBoxChannelService.pagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="esdc_module", object="esdc_ai_box_device", opType="common_op_del", requestParams={"names"}, opContent="common_dev_channelName")
    @RequiresPermissions(value={"esdc:aiboxchannel:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.esdcAiBoxChannelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"esdc:aiboxchannel:channelConfig"})
    public ModelAndView getChannelConfig(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EsdcChannelItem esdcAiBoxChannelItem = this.esdcAiBoxChannelService.getItemById(id);
            this.request.setAttribute("item", (Object)esdcAiBoxChannelItem);
            EsdcDeviceItem deviceItem = this.esdcAiBoxDeviceService.getItemById(esdcAiBoxChannelItem.getDeviceId());
            this.request.setAttribute("vendor", (Object)deviceItem.getVendor());
            if ("0".equals(deviceItem.getVendor())) {
                EsdcAiBoxChannelAlertRulesConfigItem configItem = this.esdcAiBoxChannelService.getSurveillance(id);
                if (Objects.nonNull(configItem)) {
                    this.request.setAttribute("alertType", (Object)configItem.getAlertRules().getAlertType());
                    this.request.setAttribute("configItem", (Object)configItem);
                    this.request.setAttribute("alertArea", (Object)JSON.toJSONString((Object)configItem.getAlertRules().getAlertArea()));
                }
            } else {
                String coordinate = this.esdcAiBoxChannelService.getCoordinate(esdcAiBoxChannelItem.getId(), esdcAiBoxChannelItem.getMode().intValue());
                this.request.setAttribute("alertArea", (Object)coordinate);
            }
            this.request.setAttribute("snapImage", (Object)this.esdcAiBoxChannelService.getChannelSnap(id, false));
        }
        return new ModelAndView("esdc/aiboxdevice/esdcAiBoxChannelConfig");
    }

    public ZKResultMsg jumpChannelConfig(String id) {
        return this.esdcAiBoxChannelService.jumpChannelConfig(id);
    }

    public ZKResultMsg setChannelConfig(EsdcChannelItem channelItem, EsdcAiBoxChannelAlertRulesConfigItem configItem) {
        if (Objects.nonNull(channelItem) && StringUtils.isNotBlank((CharSequence)channelItem.getDeviceId())) {
            this.esdcAiBoxChannelService.setMode(channelItem, configItem);
            switch (channelItem.getVendor()) {
                case "0": {
                    if (channelItem.getMode() == 2 || channelItem.getMode() == 3) {
                        String coordinateType = "box";
                        if (configItem.getAlertRules().getAlertType() == 1 || configItem.getAlertRules().getAlertType() == 3 || configItem.getAlertRules().getAlertType() == 7) {
                            coordinateType = "line";
                        }
                        this.esdcAiBoxChannelService.setSurveillance(channelItem.getId(), configItem, coordinateType);
                        this.esdcAiBoxChannelService.bindingAllFaceGroups(channelItem.getId(), 1);
                        break;
                    }
                    if (channelItem.getMode() != 1) break;
                    this.esdcAiBoxChannelService.bindingAllFaceGroups(channelItem.getId(), 0);
                    break;
                }
                case "1": {
                    break;
                }
            }
        }
        return ZKResultMsg.successMsg();
    }

    public TreeItem getTargetAlarmType() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        Map esdcN3TargetAlarmTypeSort = EsdcConstants.ESDC_N3_TARGET_ALARM_TYPE_SORT;
        for (String key : esdcN3TargetAlarmTypeSort.keySet()) {
            TreeItem item = new TreeItem();
            item.setId(key);
            item.setText((String)esdcN3TargetAlarmTypeSort.get(key));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getChannelByDeviceId(String deviceId) {
        ZKResultMsg zmg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            List esdcChannelItems = this.esdcAiBoxChannelService.getChannelByDeviceId(deviceId);
            zmg.setData(CollectionUtils.isEmpty((Collection)esdcChannelItems) ? "" : esdcChannelItems);
            return zmg;
        }
        return ZKResultMsg.failMsg();
    }
}

