/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.util;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttImportWithRowNumUtil {
    private static final Logger log = LoggerFactory.getLogger(AttImportWithRowNumUtil.class);

    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        Workbook workbook = AttImportWithRowNumUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        DataFormatter formatter = new DataFormatter();
        ArrayList<T> list = new ArrayList<T>();
        Field field = null;
        try {
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                if (rowNum <= 1) continue;
                T t = cls.newInstance();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    if (StringUtils.isBlank((CharSequence)formatter.formatCellValue(columnNameCell))) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    String cellValue = formatter.formatCellValue(cell);
                    String columnName = formatter.formatCellValue(columnNameCell);
                    field = fieldList.stream().filter(f -> columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    String formatStr = field.getAnnotation(GridColumn.class).format();
                    if (!"".equals(formatStr)) {
                        String[] splitArr = StringUtils.split((String)formatStr, (String)",");
                        List<String> fomatString = Arrays.asList(splitArr);
                        HashMap formatMap = Maps.newHashMap();
                        for (String s : fomatString) {
                            String[] splitEqual = s.split("=");
                            formatMap.put(I18nUtil.i18nCode((String)splitEqual[1], (Object[])new Object[0]), splitEqual[0]);
                        }
                        Set strValue = formatMap.keySet();
                        if (strValue.contains(cellValue)) {
                            field.set(t, ConvertUtils.convert(formatMap.get(cellValue), field.getType()));
                            continue;
                        }
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"att_import_existIllegalType", (Object[])new Object[]{I18nUtil.i18nCode((String)field.getAnnotation(GridColumn.class).label(), (Object[])new Object[0])}));
                    }
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = AttImportWithRowNumUtil.getDateFormt(dateType);
                        if (cell.getCellType() == CellType.NUMERIC) {
                            if (!(cell.getNumericCellValue() > 0.0)) continue;
                            field.set(t, org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            continue;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)cellValue)) continue;
                        field.set(t, DateUtil.stringToDate((String)cellValue, (String)format));
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)cellValue)) continue;
                    field.set(t, ConvertUtils.convert((String)cellValue, field.getType()));
                }
                field = cls.getDeclaredField("rowNum");
                field.setAccessible(true);
                field.set(t, ConvertUtils.convert((Object)(rowNum + 1), Integer.class));
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            log.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = AttImportWithRowNumUtil.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    public static Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        Workbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        workbook = WorkbookFactory.create((InputStream)inputStream);
        return workbook;
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
            }
        }
        return format;
    }
}

