/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.util;

import com.zkteco.zkbiosecurity.att.bean.AttUsbTransactionBean;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttImportUtil {
    private static final Logger log = LoggerFactory.getLogger(AttImportUtil.class);

    public static List<AttUsbTransactionBean> getUsbFile(InputStream inputStream) {
        ArrayList<AttUsbTransactionBean> list = new ArrayList<AttUsbTransactionBean>();
        try {
            int len = 0;
            byte[] buffer = new byte[inputStream.available()];
            String message = "";
            while ((len = inputStream.read(buffer)) != -1) {
                message = new String(buffer, 0, len, "GBK");
            }
            String[] arr = message.split("\n");
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                boolean isLineNull = false;
                String[] line = arr[i].split("\t");
                if (line.length < 6) continue;
                for (int ll = 0; ll < line.length; ++ll) {
                    if (line[ll] == null) {
                        isLineNull = true;
                        break;
                    }
                    line[ll] = AttImportUtil.replaceBlank(line[ll]);
                }
                if (isLineNull) continue;
                AttUsbTransactionBean usbTrans = null;
                if (line.length == 6) {
                    usbTrans = new AttUsbTransactionBean(line[0], line[1], line[2], line[3], line[4], line[5]);
                } else if (line.length == 7) {
                    usbTrans = new AttUsbTransactionBean(line[0], line[1], line[2], line[3], line[4], line[5], line[6]);
                } else if (line.length == 8) {
                    usbTrans = new AttUsbTransactionBean(line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7]);
                }
                if (usbTrans == null) continue;
                list.add(usbTrans);
            }
        }
        catch (Exception e) {
            log.error("read file error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static List<AttUsbTransactionBean> usbImport(InputStream inputStream) {
        List<AttUsbTransactionBean> list;
        try {
            list = AttImportUtil.getUsbFile(inputStream);
        }
        catch (ZKBusinessException e) {
            log.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static String replaceBlank(String str) {
        String dest = null;
        if (str == null) {
            return dest;
        }
        String regStartSpace = "^[ ]*";
        String regEndSpace = "[ ]*$";
        dest = str.replaceAll(regStartSpace, "").replaceAll(regEndSpace, "");
        return dest;
    }
}

