/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ZKBaseFontUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AttExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(AttExcelUtil.class);
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XSLM = "xlsm";
    public static final String PDF = "pdf";
    public static final String CSV = "csv";
    public static final String TXT = "txt";
    public static final String IMPORT_RESULT = "import-result:";
    public static final String EXPORT_RESULT = "export-result:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    private static final Logger loger = LoggerFactory.getLogger(AttExcelUtil.class);

    public <T> List<T> excelImportDynamic(InputStream inputStream, Class<T> cls, String dynamicFieldName, Map<String, String> dynamicMap, String dynamicRegex) {
        Workbook workbook = this.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (Row row : sheet) {
                if (row.getRowNum() <= 1) continue;
                T t = cls.newInstance();
                HashMap<String, String> attrMap = new HashMap<String, String>();
                for (Cell cell : row) {
                    boolean flag;
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    if (columnNameCell == null) continue;
                    columnNameCell.setCellType(CellType.STRING);
                    if (StringUtils.isEmpty((Object)columnNameCell.getStringCellValue())) {
                        throw new ZKBusinessException("common_report_columnError");
                    }
                    String columnName = columnNameCell.getStringCellValue();
                    Field field = null;
                    if (dynamicMap != null && dynamicMap.containsKey(columnName)) {
                        field = cls.getDeclaredField(dynamicFieldName);
                    }
                    if (dynamicRegex != null && (flag = Pattern.matches(dynamicRegex, columnName))) {
                        field = cls.getDeclaredField(dynamicFieldName);
                    }
                    if (field == null) {
                        field = fieldList.stream().filter(f -> columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    }
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = ExcelUtil.getDateFormt((DateType)dateType);
                        if (cell.getCellType() == CellType.NUMERIC) {
                            if (cell.getNumericCellValue() > 0.0) {
                                field.set(t, org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            }
                        } else {
                            cell.setCellType(CellType.STRING);
                            if (!StringUtils.isEmpty((Object)cell.getStringCellValue())) {
                                field.set(t, DateUtil.stringToDate((String)cell.getStringCellValue(), (String)format));
                            }
                        }
                    }
                    if (Map.class.equals(field.getType())) {
                        cell.setCellType(CellType.STRING);
                        if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                        attrMap.put(columnName, cell.getStringCellValue());
                        field.set(t, ConvertUtils.convert(attrMap, field.getType()));
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                    field.set(t, ConvertUtils.convert((String)cell.getStringCellValue(), field.getType()));
                }
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            loger.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            loger.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    private Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = this.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    private Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        Workbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        workbook = WorkbookFactory.create((InputStream)inputStream);
        return workbook;
    }

    public <T> void attExcelExport(HttpServletRequest request, HttpServletResponse response, List<T> list, Class<T> cls, Map<String, Map<String, String>> map) {
        String reportType = request.getParameter("reportType");
        String jsonColumn = request.getParameter("jsonColumn");
        String fileName = request.getParameter("tableNameParam");
        String tableName = request.getParameter("tableNameSearch");
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String gridName = fileName;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reportType)) {
            reportType = XLSX;
        }
        reportType = reportType.toLowerCase();
        try {
            String agent = request.getHeader("User-Agent").toLowerCase();
            if (request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else {
                fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
            response.setContentType("application/octet-stream");
            ServletOutputStream os = response.getOutputStream();
            this.attExcelExport(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map);
            os.flush();
        }
        catch (Exception e) {
            loger.error(fileName + " export error", (Throwable)e);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    private <T> void attExcelExport(List<T> list, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map) throws IOException {
        BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
        Object workbook = null;
        workbook = XLS.equals(reportType) ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(fileName);
        Drawing patriarch = sheet.createDrawingPatriarch();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        Object extraDataMap = new LinkedMap();
        ArrayList<Object> fieldList = new ArrayList<Object>();
        String extraDataName = "";
        try {
            for (String s : jsonObject.keySet()) {
                Field field = cls.getDeclaredField(s);
                field.setAccessible(true);
                if (field.getAnnotation(GridColumn.class) != null && !field.getAnnotation(GridColumn.class).isExportExcel()) continue;
                if ("java.util.Map".equals(cls.getDeclaredField(s).getType().getTypeName())) {
                    extraDataMap = (Map)field.get(list.get(0));
                    extraDataName = s;
                    for (Map.Entry entry : extraDataMap.entrySet()) {
                        fieldList.add(entry.getKey());
                    }
                    continue;
                }
                fieldList.add(s);
            }
            CellStyle headStyle = workbook.createCellStyle();
            Font headFont = workbook.createFont();
            headFont.setFontName("ARIAL");
            headFont.setFontHeightInPoints((short)14);
            headFont.setBold(true);
            headStyle.setFont(headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            CellStyle titleStyle = workbook.createCellStyle();
            Font titleFont = workbook.createFont();
            titleFont.setFontName("ARIAL");
            titleFont.setFontHeightInPoints((short)13);
            titleStyle.setFont(titleFont);
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setWrapText(true);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
            int isMergedRegion = 2;
            Row headRow = sheet.createRow(0);
            Cell headCell = headRow.createCell(0);
            headRow.setHeightInPoints(20.0f);
            headRow.setHeight((short)600);
            headCell.setCellStyle(headStyle);
            headCell.setCellValue(fileName);
            Row titleRow = sheet.createRow(1);
            titleRow.setHeightInPoints(20.0f);
            titleRow.setHeight((short)500);
            Row titleRowEx = sheet.createRow(2);
            int mergedRow = 0;
            int mergedRowj = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                CellRangeAddress region;
                String width = "";
                String columValue = "";
                String secHeader = "";
                if (!extraDataMap.containsKey(fieldList.get(i))) {
                    width = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).width();
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).label();
                    secHeader = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).secHeader();
                } else {
                    width = "90";
                    columValue = (String)fieldList.get(i);
                }
                if (StringUtils.isEmpty((Object)columValue)) {
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getName();
                }
                if (!StringUtils.isEmpty((Object)width) && !"*".equals(width)) {
                    sheet.setColumnWidth(i, 50 * Integer.parseInt(width));
                }
                Cell columCell = titleRow.createCell(i);
                columCell.setCellStyle(titleStyle);
                if (!"".equals(secHeader) && !"#cspan".equals(columValue)) {
                    Cell columCell3 = titleRowEx.createCell(i);
                    columCell3.setCellStyle(titleStyle);
                    columCell3.setCellValue(I18nUtil.i18nCode((String)secHeader, (Object[])new Object[0]));
                }
                if (!"".equals(secHeader) && "#cspan".equals(columValue)) {
                    ++mergedRow;
                    ++mergedRowj;
                    columCell = titleRowEx.createCell(i);
                    columValue = secHeader;
                    isMergedRegion = 3;
                } else {
                    if (mergedRowj != 0) {
                        region = new CellRangeAddress(1, 1, i - mergedRowj - 1, i - 1);
                        sheet.addMergedRegion(region);
                    }
                    mergedRowj = 0;
                }
                if (mergedRowj != 0 && i == fieldList.size() - 1) {
                    region = new CellRangeAddress(1, 1, i - mergedRowj, i);
                    sheet.addMergedRegion(region);
                }
                if ("".equals(secHeader) && mergedRow != 0) {
                    region = new CellRangeAddress(1, 2, i, i);
                    sheet.addMergedRegion(region);
                }
                Comment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                comment.setString((RichTextString)new HSSFRichTextString(this.getCellCommentByField(cls.getDeclaredField((String)fieldList.get(i)).getName(), cls.getSimpleName())));
                columCell.setCellComment(comment);
                columCell.setCellStyle(titleStyle);
                columCell.setCellValue(I18nUtil.i18nCode((String)columValue, (Object[])new Object[0]));
            }
            String cellValue = "";
            CreationHelper creationHelper = workbook.getCreationHelper();
            for (int i = 0; i < list.size(); ++i) {
                Row dataRows = sheet.createRow(i + isMergedRegion);
                for (int j = 0; j < fieldList.size(); ++j) {
                    Field field;
                    Cell dataCell = dataRows.createCell(j);
                    dataCell.setCellStyle(cellStyle);
                    if (!extraDataMap.containsKey(fieldList.get(j))) {
                        field = cls.getDeclaredField((String)fieldList.get(j));
                        field.setAccessible(true);
                        Object cellObject = field.get(list.get(i));
                        if (field.getName().contains("picture") && cellObject != null) {
                            Hyperlink hyperLink = creationHelper.createHyperlink(HyperlinkType.FILE);
                            hyperLink.setAddress((String)cellObject);
                            dataCell.setHyperlink(hyperLink);
                        }
                        if (!StringUtils.isEmpty((Object)cellObject)) {
                            if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                                DateType dateType = field.getAnnotation(DateType.class);
                                String format = this.getDateFormt(dateType);
                                cellValue = new SimpleDateFormat(format).format(cellObject);
                            } else if (map != null && map.containsKey(field.getName())) {
                                cellValue = String.valueOf(cellObject);
                                if (map.get(field.getName()).containsKey(cellValue)) {
                                    cellValue = I18nUtil.i18nCode((String)map.get(field.getName()).get(cellValue), (Object[])new Object[0]);
                                }
                            } else {
                                cellValue = String.valueOf(cellObject);
                                if (field.getAnnotation(GridColumn.class).i18n()) {
                                    cellValue = I18nUtil.i18nCode((String)cellValue, (Object[])new Object[0]);
                                }
                                if (!StringUtils.isEmpty((Object)field.getAnnotation(GridColumn.class).format())) {
                                    cellValue = I18nUtil.i18nCode((String)GridUtil.getDictionaryVal((String)field.getAnnotation(GridColumn.class).format(), (Object)cellValue), (Object[])new Object[0]);
                                }
                            }
                        } else {
                            cellValue = "";
                        }
                    } else {
                        field = cls.getDeclaredField(extraDataName);
                        field.setAccessible(true);
                        Map extraDataMaps = (Map)field.get(list.get(i));
                        cellValue = String.valueOf(extraDataMaps.get(fieldList.get(j)));
                    }
                    dataCell.setCellValue(cellValue);
                    if (!StringUtils.isEmpty((Object)cellValue) && !"null".equals(cellValue)) continue;
                    dataCell.setCellValue("");
                }
            }
            if (PDF.equals(reportType)) {
                this.ExecltoPdf((Workbook)workbook, ops);
            } else if (CSV.equals(reportType) || TXT.equals(reportType)) {
                this.ExecltoCsv((Workbook)workbook, ops);
            } else {
                workbook.write((OutputStream)ops);
            }
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
        }
        ((OutputStream)ops).flush();
        ((OutputStream)ops).close();
        outputStream.close();
    }

    private void ExecltoPdf(Workbook workbook, OutputStream out) throws DocumentException, FileNotFoundException {
        try {
            Document iText_xls_2_pdf = new Document(PageSize.A3, 50.0f, 50.0f, 50.0f, 50.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)iText_xls_2_pdf, (OutputStream)out);
            Header header = new Header();
            writer.setPageEvent((PdfPageEvent)header);
            iText_xls_2_pdf.open();
            int sheetSize = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetSize; ++i) {
                Sheet my_worksheet = workbook.getSheetAt(i);
                for (Row row : my_worksheet) {
                    int num = row.getPhysicalNumberOfCells();
                    if (num == 0) continue;
                    PdfPTable my_table = new PdfPTable(num);
                    my_table.setWidthPercentage(100.0f);
                    int[] widths = new int[num];
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        switch (cell.getCellType()) {
                            case STRING: {
                                PdfPCell table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getBodyFont((String)cell.getStringCellValue())));
                                table_cell.setHorizontalAlignment(1);
                                if (1 == cell.getRowIndex()) {
                                    table_cell.setBackgroundColor(new BaseColor(217, 217, 217));
                                } else if (0 == cell.getRowIndex()) {
                                    table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getTitleFont((String)cell.getStringCellValue())));
                                    table_cell.setBorder(0);
                                    table_cell.setPaddingBottom(20.0f);
                                    table_cell.setHorizontalAlignment(1);
                                }
                                widths[cell.getColumnIndex()] = my_worksheet.getColumnWidth(cell.getColumnIndex());
                                my_table.addCell(table_cell);
                                break;
                            }
                        }
                    }
                    my_table.setWidths(widths);
                    iText_xls_2_pdf.add((Element)my_table);
                }
            }
            iText_xls_2_pdf.close();
            writer.close();
        }
        catch (Exception e) {
            log.error("exception = ", (Throwable)e);
        }
    }

    private void ExecltoCsv(Workbook workbook, OutputStream out) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        out.write(uft8bom);
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        Sheet my_worksheet = workbook.getSheetAt(0);
        Iterator rowIterator = my_worksheet.iterator();
        try {
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                int num = row.getPhysicalNumberOfCells();
                if (num == 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case STRING: {
                            bw.append("\"" + cell.getStringCellValue() + "\"");
                            bw.append(",");
                            break;
                        }
                    }
                }
                bw.append(System.getProperty("line.separator"));
            }
            bw.flush();
            out.close();
            bw.close();
            osw.close();
        }
        catch (IOException e) {
            log.error("exception = ", (Throwable)e);
        }
    }

    private String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
            }
        }
        return format;
    }

    private String getCellCommentByField(String field, String className) {
        String cellComment = I18nUtil.i18nCode((String)"att_exception_cellDefault", (Object[])new Object[0]);
        switch (field) {
            case "pin": 
            case "personPin": 
            case "authAreaNo": 
            case "adjustPersonPin": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellRequired", (Object[])new Object[0]);
                break;
            }
            case "signDatetime": 
            case "startDatetime": 
            case "endDatetime": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellDateTime", (Object[])new Object[0]);
                break;
            }
            case "leaveTypeName": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellLeaveTypeName", (Object[])new Object[0]);
                break;
            }
            case "overtimeSign": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellOvertimeSign", (Object[])new Object[0]);
                break;
            }
            case "adjustType": {
                if ("AttClassItem".equals(className)) {
                    cellComment = MessageFormat.format(I18nUtil.i18nCode((String)"att_exception_cellClassAdjustType", (Object[])new Object[0]), I18nUtil.i18nCode((String)"att_class_sameTimeMoveShift", (Object[])new Object[0]), I18nUtil.i18nCode((String)"att_class_differenceTimeMoveShift", (Object[])new Object[0]), I18nUtil.i18nCode((String)"att_class_twoPeopleMove", (Object[])new Object[0]));
                    break;
                }
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellAdjustType", (Object[])new Object[0]);
                break;
            }
            case "adjustDate": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellAdjustDate", (Object[])new Object[0]);
                break;
            }
            case "swapDate": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_swapDateDate", (Object[])new Object[0]);
                break;
            }
            case "shiftName": {
                cellComment = I18nUtil.i18nCode((String)"att_exception_cellShiftName", (Object[])new Object[0]);
                break;
            }
        }
        return cellComment;
    }

    private static class Header
    extends PdfPageEventHelper {
        private Header() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)2, (Phrase)new Phrase("Page:" + pdfWriter.getCurrentPageNumber()), (float)450.0f, (float)30.0f, (float)0.0f);
        }
    }
}

