/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.ui;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.PropertiesUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.DIV;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKUIDirective(script="js/ZKPersSelect.js")
public class SelectPersContent
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        boolean enableRTL = PropertiesUtil.enableRTL();
        JSONObject options = new JSONObject();
        this.addRequestParams(options);
        BeanUtil.setParamsToJson((JSONObject)options, (Map)params);
        String gridName = options.getString("gridName");
        if (StringUtils.isEmpty((CharSequence)gridName)) {
            gridName = "gridbox" + BeanUtil.getUUID();
        }
        options.put("gridName", (Object)gridName);
        DIV doc = new DIV();
        doc.addAttributesOnly(params).id(gridName).addClass("select_layout_box");
        HTMLElement topBox = doc.div().id(gridName + "Top").addClass("select_top_box");
        HTMLElement gridBox = doc.div().id(gridName + "Grid").addClass("select_grid_box");
        HTMLElement leftTree = doc.div().id(gridName + "Left").addClass("dhx_left_tree_box");
        leftTree.div().addClass("dhx_tree_box").div().id("leftTree" + gridName);
        HTMLElement centerBox = doc.div().id(gridName + "Center");
        centerBox.div().addClass("select_content_title");
        HTMLElement pagerDive = centerBox.div().addClass("select_content_grid").div().id("center" + gridName);
        pagerDive.parent().div().id("center" + gridName + "_paging");
        HTMLElement rightBox = doc.div().id(gridName + "Right");
        rightBox.div().addClass("select_content_title");
        rightBox.div().addClass("select_content_grid").div().id("right" + gridName);
        JSONObject optionsTemp = (JSONObject)env.getCurrentNamespace().toMap().get("options");
        env.getCurrentNamespace().put("options", (Object)options);
        if (body != null) {
            options.put("gridName", (Object)("center" + gridName));
            options.put("onQuery", (Object)gridName);
            StringWriter bodystr = new StringWriter();
            body.render((Writer)bodystr);
            options.put("gridName", (Object)gridName);
            options.put("content", (Object)URLEncoder.encode(bodystr.toString().replaceAll("[\r\n\t]", "").trim(), "utf-8"));
        } else {
            options.put("content", (Object)"");
        }
        env.getCurrentNamespace().put("options", (Object)optionsTemp);
        if (StringUtils.isEmpty((CharSequence)options.getString("noButtonContent")) || !options.getString("noButtonContent").equals("true")) {
            JSONObject buttonContent = options.getJSONObject("buttonContent");
            HTMLElement bottomBox = doc.div().id(gridName + "Bottom").addClass("select_bottom_btn");
            if (buttonContent == null) {
                buttonContent = options.getJSONObject("addButtonContent");
                if (buttonContent != null) {
                    bottomBox.appendContent(buttonContent.getString("body"));
                    buttonContent.remove((Object)"body");
                }
                HTMLElement bottomTemp = Document.createElement();
                bottomTemp.button().addClass("button-form").text(I18nUtil.i18nCode((String)BeanUtil.getParam((Map)params, (String)"okText", (String)"common_edit_ok"), (Object[])new Object[0])).id(gridName + "ok");
                bottomTemp.button().addClass("button-form").text(I18nUtil.i18nCode((String)BeanUtil.getParam((Map)params, (String)"cancelText", (String)"common_edit_cancel"), (Object[])new Object[0])).id(gridName + "cancel");
                bottomBox.appendContent(bottomTemp.toString());
            } else {
                bottomBox.appendContent(buttonContent.getString("body"));
                buttonContent.remove((Object)"body");
            }
        } else {
            gridBox.style("bottom:0px");
        }
        if (!StringUtils.isEmpty((CharSequence)options.getString("topHeight"))) {
            topBox.style("height:" + options.getString("topHeight") + "px");
            gridBox.style(gridBox.attr("style") + ";top:" + options.getString("topHeight") + "px");
        }
        String vo = BeanUtil.getParam((Map)params, (String)"vo", (String)"");
        JSONObject gridData = GridUtil.getGridHeader((String)vo, (String)gridName);
        options.putAll((Map)gridData);
        if (StringUtils.isNotBlank((CharSequence)options.getString("rightVo"))) {
            options.put("rightColumns", (Object)GridUtil.getGridHeader((String)options.getString("rightVo"), (String)("right" + gridName)));
        }
        if (StringUtils.isBlank((CharSequence)options.getString("setMode"))) {
            options.put("setMode", (Object)"true,true,false");
        }
        if (enableRTL) {
            options.put("enableRTL", (Object)true);
        }
        doc.script().appendContent("new ZKUI.PersSelect(" + options.toJSONString() + ");");
        Writer out = env.getOut();
        out.write(doc.toString());
    }

    private void addRequestParams(JSONObject opts) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            opts.put(name, (Object)request.getParameter(name));
        }
    }
}

