/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.dhx;

import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonthDetailDyna
implements DynamicColumn {
    @Autowired
    private AttParamService attParamService;

    public List<GridColumnItem> getColumn(String filedName) {
        HttpServletRequest request = WebContextUtil.getCurrentRequest();
        String startDate = request.getParameter("monthStart");
        String endDate = request.getParameter("monthEnd");
        String queryCondition = request.getParameter("queryConditions");
        if (queryCondition != null) {
            String[] conditionAry;
            for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
                if (StringUtils.isBlank((CharSequence)condition)) continue;
                String[] strAry = condition.split("=", 2);
                String fieldName = strAry[0];
                String fieldValue = strAry[1];
                if ("monthStart".equals(fieldName)) {
                    startDate = fieldValue;
                    continue;
                }
                if (!"monthEnd".equals(fieldName)) continue;
                endDate = fieldValue;
            }
        }
        List dayList = AttDateUtils.getBetweenDate((String)startDate, (String)AttDateUtils.getEndDate((String)startDate, (String)endDate));
        ArrayList<GridColumnItem> columns = new ArrayList<GridColumnItem>();
        for (int i = 1; i <= dayList.size(); ++i) {
            GridColumnItem c1 = new GridColumnItem();
            c1.setName((String)dayList.get(i - 1));
            c1.setColumnType("ro");
            c1.setSort("na");
            c1.setLabel("#cspan");
            c1.setWidth("110");
            c1.setSortNo(i + 10);
            c1.setSecHeader(AttDateUtils.getWeekName((Date)DateUtil.stringToDate((String)((String)dayList.get(i - 1)))));
            String labelDate = this.attParamService.dateToLocaleString(DateUtil.stringToDate((String)((String)dayList.get(i - 1))));
            c1.setLabel(labelDate);
            c1.setFieldName(filedName);
            columns.add(c1);
        }
        return columns;
    }
}

