/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.dhx;

import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LeaveTypeDyna
implements DynamicColumn {
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;

    public List<GridColumnItem> getColumn(String fieldName) {
        ArrayList<GridColumnItem> columns = new ArrayList<GridColumnItem>();
        List attLeaveTypeItemList = this.attLeaveTypeService.getLeaveTypeItems();
        for (int i = 0; i < attLeaveTypeItemList.size(); ++i) {
            AttLeaveTypeItem attLeaveType = (AttLeaveTypeItem)attLeaveTypeItemList.get(i);
            String leaveTypeNameUnit = this.attLeaveTypeService.getConvertUnit(attLeaveType);
            GridColumnItem count = new GridColumnItem();
            count.setName(attLeaveType.getLeaveTypeName() + I18nUtil.i18nCode((String)"att_statistical_numberOfTimes", (Object[])new Object[0]));
            count.setColumnType("custom");
            count.setConvert("attLeaveViewDetail");
            count.setSort("na");
            count.setSortNo(i * 2 + 7);
            count.setWidth("70");
            count.setLabel(leaveTypeNameUnit);
            count.setSecHeader(I18nUtil.i18nCode((String)"att_statistical_numberOfTimes", (Object[])new Object[0]));
            count.setFieldName(fieldName);
            columns.add(count);
            GridColumnItem sum = new GridColumnItem();
            sum.setName(leaveTypeNameUnit);
            sum.setColumnType("ro");
            sum.setSort("na");
            sum.setSortNo(count.getSortNo() + 1);
            sum.setWidth("70");
            sum.setLabel("#cspan");
            sum.setSecHeader(I18nUtil.i18nCode((String)"att_common_timeLongs", (Object[])new Object[0]));
            sum.setFieldName(fieldName);
            columns.add(sum);
        }
        return columns;
    }
}

