/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.dhx;

import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttPersonSchDynamicColumn
implements DynamicColumn {
    @Autowired
    private AttParamService attParamService;

    public List<GridColumnItem> getColumn(String filedName) {
        String queryCondition;
        ArrayList<GridColumnItem> columns = new ArrayList<GridColumnItem>();
        HttpServletRequest request = WebContextUtil.getCurrentRequest();
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        if (StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            startDate = DateUtil.getDate((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD);
            endDate = AttDateUtils.dateToStrAsShort((Date)DateUtil.addMonth((Date)DateUtil.stringToDate((String)startDate, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD), (int)1));
        }
        if ((queryCondition = request.getParameter("queryConditions")) != null) {
            String[] conditionAry;
            for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
                if (StringUtils.isBlank((CharSequence)condition)) continue;
                String[] strAry = condition.split("=", 2);
                String fieldName = strAry[0];
                String fieldValue = strAry[1];
                if ("startDate".equals(fieldName)) {
                    startDate = fieldValue;
                    continue;
                }
                if (!"endDate".equals(fieldName)) continue;
                endDate = fieldValue;
            }
        }
        List dayList = AttDateUtils.getBetweenDate((String)startDate, (String)AttDateUtils.getEndDate((String)startDate, (String)endDate));
        for (int i = 1; i <= dayList.size(); ++i) {
            GridColumnItem columnItem = new GridColumnItem();
            columnItem.setName((String)dayList.get(i - 1));
            columnItem.setColumnType("ro");
            columnItem.setSort("na");
            columnItem.setLabel("#cspan");
            columnItem.setWidth("110");
            columnItem.setSortNo(i + 5);
            String labelDate = this.attParamService.dateToLocaleString(DateUtil.stringToDate((String)((String)dayList.get(i - 1))));
            columnItem.setLabel(labelDate);
            columnItem.setFieldName(filedName);
            columns.add(columnItem);
        }
        return columns;
    }
}

