/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttWfApplyRemote;
import com.zkteco.zkbiosecurity.att.service.AttFlowableService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WFSelfApplyController
extends BaseController
implements AttWfApplyRemote {
    @Autowired
    private AttFlowableService attFlowableService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private HttpServletRequest request = null;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;

    public ModelAndView apply(String flowType) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        String personId = "-1";
        String personPin = "";
        if (Objects.nonNull(attPersonItem)) {
            personId = attPersonItem.getPersonId();
            personPin = attPersonItem.getPersonPin();
        }
        if (personId != null && this.request.getAttribute("task") == null) {
            Map firstNotifier = this.attFlowableService.apply(personId, flowType);
            HashMap<String, Map> task = new HashMap<String, Map>();
            task.put("notifierPers", firstNotifier);
            this.request.setAttribute("task", task);
        }
        this.request.setAttribute("personId", (Object)personId);
        this.request.setAttribute("personPin", (Object)personPin);
        this.request.setAttribute("leaveTypeTripId", (Object)this.attLeaveTypeService.getItemByLeaveTypeNo("trip").getId());
        this.request.setAttribute("leaveTypeOutId", (Object)this.attLeaveTypeService.getItemByLeaveTypeNo("out").getId());
        this.request.setAttribute("flowType", (Object)flowType);
        return new ModelAndView("att/flowable/" + flowType + "/editAtt" + StrUtil.toUpperCase((String)flowType.substring(0, 1)) + flowType.substring(1));
    }

    public ModelAndView approve(String taskId) {
        Map resMap = this.attFlowableService.approve(taskId);
        this.request.setAttribute("item", resMap.get("item"));
        this.request.setAttribute("task", resMap.get("task"));
        return this.apply(resMap.get("flowType").toString());
    }

    public ModelAndView detail(String businessKey) {
        Map resMap = this.attFlowableService.detail(businessKey);
        this.request.setAttribute("item", resMap.get("item"));
        this.request.setAttribute("task", resMap.get("task"));
        this.request.setAttribute("detail", (Object)"readonly");
        return this.apply(resMap.get("flowType").toString());
    }

    public ModelAndView cancelApply(String businessKey) {
        this.request.setAttribute("businessKey", (Object)businessKey);
        return new ModelAndView("/att/flowable/cancelApply");
    }

    public ZKResultMsg validApplyFlow(String flowType) {
        try {
            SecuritySubject securitySubject = this.getCurrentSubject();
            AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
            if (Objects.nonNull(attPersonItem)) {
                this.attFlowableService.apply(attPersonItem.getPersonId(), flowType);
            }
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
        return ZKResultMsg.successMsg();
    }
}

