/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.constants.AttConstant;
import com.zkteco.zkbiosecurity.att.remote.AttTimeSlotRemote;
import com.zkteco.zkbiosecurity.att.service.AttRuleService;
import com.zkteco.zkbiosecurity.att.service.AttTimeSlotService;
import com.zkteco.zkbiosecurity.att.vo.AttTimeSlotBreakTimeItem;
import com.zkteco.zkbiosecurity.att.vo.AttTimeSlotItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTimeSlotController
extends BaseController
implements AttTimeSlotRemote {
    @Autowired
    private AttTimeSlotService attTimeSlotService;
    @Autowired
    private AttRuleService attRuleService;

    @RequiresPermissions(value={"att:timeSlot"})
    public ModelAndView index() {
        return new ModelAndView("att/timeSlot/attTimeSlot");
    }

    @RequiresPermissions(value={"att:timeSlot:edit"})
    public ModelAndView edit(String id) {
        String periodType = this.request.getParameter("periodType");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttTimeSlotItem item = this.attTimeSlotService.getItemById(id);
            periodType = item.getPeriodType() + "";
            this.request.setAttribute("item", (Object)item);
        }
        Map attParams = this.attRuleService.getAttParams();
        this.request.setAttribute("attParams", (Object)attParams);
        if ("0".equals(periodType)) {
            return new ModelAndView("att/timeSlot/editAttTimeSlot");
        }
        return new ModelAndView("att/timeSlot/editAttTimeSlotElastic");
    }

    @RequiresPermissions(value={"att:timeSlot:edit"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_timeSlot", opType="common_op_edit", vo=AttTimeSlotItem.class, service=AttTimeSlotService.class)
    public ZKResultMsg save(AttTimeSlotItem item) {
        this.attTimeSlotService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:timeSlot:refresh"})
    public DxGrid list(AttTimeSlotItem condition) {
        Pager pager = this.attTimeSlotService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:timeSlot:del"})
    @LogRequest(module="att_module", object="att_leftMenu_timeSlot", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        if (this.attTimeSlotService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_common_relationDataCanNotDel", (Object[])new Object[0]));
        }
        this.attTimeSlotService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public String validName(String periodName) {
        boolean rs = !this.attTimeSlotService.existsByPeriodName(periodName);
        return rs + "";
    }

    public DxGrid breakTimeList(AttTimeSlotBreakTimeItem condition) {
        Pager pager = this.attTimeSlotService.findBreakTimeListByTimeSlotId(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg addBreakTime(String timeSlotId, String breakTimeIds) {
        String result = this.attTimeSlotService.addBreakTime(timeSlotId, breakTimeIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
    }

    public ZKResultMsg delBreakTime(String timeSlotId, String breakTimeIds) {
        this.attTimeSlotService.delBreakTime(timeSlotId, breakTimeIds);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg countSegmentTime(String timeSlotId, String breakTimeArray) {
        int timeLong = this.attTimeSlotService.countSegmentTime(timeSlotId, breakTimeArray);
        return new ZKResultMsg((Object)timeLong);
    }

    public ZKResultMsg timeJudgment(String timeSlotId, String toWorkTime, String offWorkTime) {
        String result = this.attTimeSlotService.timeJudgment(timeSlotId, toWorkTime, offWorkTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
    }

    public ZKResultMsg breakTimeIsInWorkTime(String breakTimeListStr, String toWorkTime, String offWorkTime) {
        String result = this.attTimeSlotService.breakTimeIsInWorkTime(breakTimeListStr, toWorkTime, offWorkTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)result));
    }

    public ZKResultMsg getNormalList() {
        AttTimeSlotItem attTimeSlotItem = new AttTimeSlotItem();
        attTimeSlotItem.setPeriodType(AttConstant.PERIODTYPE_NORMAL);
        List attTimeSlotItemList = this.attTimeSlotService.getByCondition(attTimeSlotItem);
        return new ZKResultMsg((Object)attTimeSlotItemList);
    }

    public TreeItem getTree() {
        return this.attTimeSlotService.getTree();
    }

    public ZKResultMsg getAllList() {
        List attTimeSlotItemList = this.attTimeSlotService.getByCondition(new AttTimeSlotItem());
        return new ZKResultMsg((Object)attTimeSlotItemList);
    }
}

