/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.att.bean.AttDXCalendarEventBean;
import com.zkteco.zkbiosecurity.att.constants.AttCommonSchConstant;
import com.zkteco.zkbiosecurity.att.remote.AttTempSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttGroupService;
import com.zkteco.zkbiosecurity.att.service.AttTempSchService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttGroupItem;
import com.zkteco.zkbiosecurity.att.vo.AttTempSchItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTempSchController
extends ExportController
implements AttTempSchRemote {
    @Autowired
    private AttTempSchService attTempSchService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AttGroupService attGroupService;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:tempsch:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttTempSchItem attTempSchItem = this.attTempSchService.getItemById(id);
            this.setShowInfo(attTempSchItem);
            AttDXCalendarEventBean dXCalendarEvent = new AttDXCalendarEventBean();
            dXCalendarEvent.setAttTimeSlotIds(attTempSchItem.getTimeSlotIds());
            dXCalendarEvent.setStart_date(attTempSchItem.getStartDate());
            int days = AttDateUtils.diffDays((Date)attTempSchItem.getStartDate(), (Date)attTempSchItem.getEndDate());
            if (days > 0) {
                dXCalendarEvent.setEnd_date(DateUtil.addDay((Date)attTempSchItem.getEndDate(), (int)1));
                dXCalendarEvent.set_timed(false);
            } else {
                dXCalendarEvent.setEnd_date(attTempSchItem.getEndDate());
            }
            dXCalendarEvent.setText(attTempSchItem.getTimeSlotName());
            this.request.setAttribute("type", (Object)attTempSchItem.getTempType());
            this.request.setAttribute("dXCalendarEvent", (Object)dXCalendarEvent);
            this.request.setAttribute("item", (Object)attTempSchItem);
        }
        return new ModelAndView("att/personSch/editAttTempSch");
    }

    private void setShowInfo(AttTempSchItem attTempSchItem) {
        if (AttCommonSchConstant.SCH_TYPE_PERSON.equals(attTempSchItem.getTempType())) {
            PersPersonItem personItem = this.persPersonService.getSimpleItemById(attTempSchItem.getPersonId());
            if (personItem != null) {
                this.request.setAttribute("showInfo", (Object)(personItem.getName() + "(" + personItem.getPin() + ")"));
            }
        } else if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(attTempSchItem.getTempType())) {
            AuthDepartmentItem authDepartmentItem = this.authDepartmentService.getItemById(attTempSchItem.getDeptId());
            this.request.setAttribute("showInfo", (Object)authDepartmentItem.getName());
        } else if (AttCommonSchConstant.SCH_TYPE_GROUP.equals(attTempSchItem.getTempType())) {
            AttGroupItem attGroupItem = this.attGroupService.getItemById(attTempSchItem.getGroupId());
            this.request.setAttribute("showInfo", (Object)attGroupItem.getGroupName());
        }
    }

    public DxGrid list(AttTempSchItem condition) {
        Pager pager = this.attTempSchService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:schDetails:del"})
    @LogRequest(module="att_module", object="att_leftMenu_schDetails", opType="att_personSch_delSch", requestParams={"names"}, opContent="common_op_del")
    public ZKResultMsg delete(String ids) {
        this.attTempSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:personsch:tempSch"})
    @LogChangeRequest(module="att_module", object="att_personSch_sch", opType="att_leftMenu_tempSch", vo=AttTempSchItem.class, service=AttTempSchService.class)
    public ZKResultMsg saveTempSch(AttTempSchItem item) {
        String addIds = this.request.getParameter("addIds");
        String dXCalendarEvent = this.request.getParameter("dXCalendarEvent");
        List attDXCalendarEventBeanList = JSONArray.parseArray((String)dXCalendarEvent, AttDXCalendarEventBean.class);
        if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(item.getTempType())) {
            addIds = this.includeLowerDept(addIds);
        }
        this.attTempSchService.saveTempSch(addIds, item, attDXCalendarEventBeanList);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:personsch:cleanTempSch"})
    @LogRequest(module="att_module", object="att_personSch_sch", opType="att_personSch_cleanTempSch", requestParams={"names"}, opContent="att_personSch_cleanTempSch")
    public ZKResultMsg delTempSch(String ids, Short type, Date startDate, Date endDate) {
        if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(type)) {
            ids = this.includeLowerDept(ids);
        }
        this.attTempSchService.delTempSch(ids, type, startDate, endDate);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private String includeLowerDept(String ids) {
        String includeLower = this.request.getParameter("includeLower");
        if ("true".equals(includeLower)) {
            List departmentItems = this.authDepartmentService.getChildDeptItemsByDeptIds(ids);
            ids = Optional.ofNullable(departmentItems).filter(l -> !l.isEmpty()).map(l -> l.stream().map(AuthDepartmentItem::getId).filter(Objects::nonNull).map(String::valueOf).distinct().collect(Collectors.joining(","))).orElse(null);
        }
        return ids;
    }

    @RequiresPermissions(value={"att:personsch:exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        String begin = request.getParameter("startTime");
        String end = request.getParameter("endTime");
        ArrayList<AttTempSchItem> attTempSchItemList = new ArrayList<AttTempSchItem>();
        AttTempSchItem attTempSchItem = new AttTempSchItem();
        List dayList = AttDateUtils.getBetweenDate((String)begin, (String)end);
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < dayList.size(); ++i) {
            map.put(dayList.get(i), "");
        }
        attTempSchItem.setMap(map);
        attTempSchItemList.add(attTempSchItem);
        this.excelExport(attTempSchItemList, AttTempSchItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"att:personsch:import"})
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            this.stringRedisTemplate.opsForValue().set((Object)("import-result:" + this.request.getSession().getId()), (Object)"start");
            String dynamicRegex = "^\\d{4}(\\-|\\/)\\d{1,2}(\\-|\\/)\\d{1,2}$";
            List<AttTempSchItem> attTempSchItemList = this.attExcelUtil.excelImportDynamic(upload.getInputStream(), AttTempSchItem.class, "map", null, dynamicRegex);
            this.stringRedisTemplate.opsForValue().set((Object)("import-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("import-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attTempSchService.importExcel(attTempSchItemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttPersonSch Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"att:schDetails:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String[] conditionAry;
        AttTempSchItem attTempSchItem = new AttTempSchItem();
        this.setConditionValue((BaseItem)attTempSchItem);
        String queryCondition = request.getParameter("queryConditions");
        for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
            if (!StringUtils.isNotBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=", 2);
            String fieldName = strAry[0];
            String fieldValue = strAry[1];
            if ("startTime".equals(fieldName)) {
                attTempSchItem.setStartTime(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
                continue;
            }
            if (!"endTime".equals(fieldName)) continue;
            attTempSchItem.setEndTime(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        }
        List attCycleSchItemList = this.attTempSchService.getItemData(request.getSession().getId(), attTempSchItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(attCycleSchItemList, AttTempSchItem.class);
    }
}

