/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttSignRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttSignService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttSignItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttSignController
extends ExportController
implements AttSignRemote {
    @Autowired
    private AttSignService attSignService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:sign"})
    public ModelAndView index() {
        if (this.getCurrentSubject().getStaff().booleanValue()) {
            this.request.setAttribute("flowType", (Object)"sign");
            return new ModelAndView("att/flowable/sign/attSign");
        }
        return new ModelAndView("att/sign/attSign");
    }

    @RequiresPermissions(value={"att:sign:add"})
    public ModelAndView edit(String id) {
        AttSignItem item = this.attSignService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/sign/editAttSign");
    }

    @RequiresPermissions(value={"att:sign:add"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_new", vo=AttSignItem.class, service=AttSignService.class)
    public ZKResultMsg save(AttSignItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        List persPersonList = this.attPersonService.getItemByPersonIds((Collection)StrUtil.strToList((String)personIds));
        for (AttPersonItem attPersonItem : persPersonList) {
            Date hireDate = attPersonItem.getHireDate();
            if (hireDate == null || hireDate.getTime() <= item.getSignDatetime().getTime()) continue;
            res.setMsg(I18nUtil.i18nCode((String)"att_h5_persNoHire", (Object[])new Object[0]));
            res.setData((Object)"false");
            return res;
        }
        this.attSignService.saveItem(item, personIds, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:sign:refresh"})
    public DxGrid list(AttSignItem condition) {
        Pager pager = this.attSignService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:sign:del"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attSignService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:sign:export"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttSignItem attSignItem = new AttSignItem();
        this.setConditionValue((BaseItem)attSignItem);
        List intemList = this.attSignService.getItemData(request.getSession().getId(), attSignItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttSignItem.class);
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("personPin", (Object)"");
        jsonColumn.put("personName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("personLastName", (Object)"");
        }
        jsonColumn.put("signDatetime", (Object)"");
        jsonColumn.put("remark", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttSignItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttSignItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttSignItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attSignService.importExcel(itemList, this.request.getSession().getId()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttSign Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"att:sign:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="att_apply_pass", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg approval(String ids) {
        if (this.attSignService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attSignService.approval(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:sign:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="att_exception_refuse", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg refuse(String ids) {
        if (this.attSignService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attSignService.refuse(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

