/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttShiftRemote;
import com.zkteco.zkbiosecurity.att.service.AttShiftService;
import com.zkteco.zkbiosecurity.att.vo.AttShiftItem;
import com.zkteco.zkbiosecurity.att.vo.AttShiftSchItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttShiftController
extends BaseController
implements AttShiftRemote {
    @Autowired
    private AttShiftService attShiftService;

    @RequiresPermissions(value={"att:shift"})
    public ModelAndView index() {
        return new ModelAndView("att/shift/attShift");
    }

    @RequiresPermissions(value={"att:shift:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("timeSlotIds", (Object)this.attShiftService.getTimeSlotIds(id));
            this.request.setAttribute("item", (Object)this.attShiftService.getItemById(id));
            boolean isExist = this.attShiftService.isExistFkData(id);
            this.request.setAttribute("editPage", (Object)isExist);
        } else {
            AttShiftItem item = new AttShiftItem();
            item.setShiftType(Short.valueOf(this.request.getParameter("shiftType")));
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("att/shift/editAttShift");
    }

    public ModelAndView addTimeSlot(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttShiftItem item = this.attShiftService.getItemById(id);
            item.setTimeSlotIds(this.attShiftService.getTimeSlotIds(id));
            this.request.setAttribute("item", (Object)this.attShiftService.getItemById(id));
            if (0 == item.getShiftType()) {
                this.request.setAttribute("attTimeSlotColumns", (Object)"checkbox,periodName,toWorkTime,offWorkTime");
            } else {
                this.request.setAttribute("attTimeSlotColumns", (Object)"checkbox,periodName,startSignInTime,endSignOffTime");
            }
        }
        return new ModelAndView("att/shift/editAttShiftAddTimeSlot");
    }

    @RequiresPermissions(value={"att:shift:edit"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_shift", opType="common_op_edit", vo=AttShiftItem.class, service=AttShiftService.class)
    public ZKResultMsg save(AttShiftItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String attTimeSlotIds = this.request.getParameter("timeSlotIds");
        if (item.getShiftColor() == null) {
            item.setShiftColor("#66FF66");
        }
        if ("1".equals(item.getPeriodStartMode())) {
            item.setStartDate(null);
        }
        this.attShiftService.saveItem(item, attTimeSlotIds);
        res.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg saveTimeSlot(AttShiftItem item) {
        ZKResultMsg resultMsg = this.attShiftService.saveTimeSlot(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"att:shift:refresh"})
    public DxGrid list(AttShiftItem condition) {
        Pager pager = this.attShiftService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:shift:del"})
    @LogRequest(module="att_module", object="att_leftMenu_shift", opType="common_op_del", requestParams={"shiftName"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        if (this.attShiftService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_common_relationDataCanNotDel", (Object[])new Object[0]));
        }
        this.attShiftService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public Map<String, Object> getAttTimeSlotJson() {
        String id = this.request.getParameter("id");
        List tsdList = this.attShiftService.listTsd(id);
        AttShiftItem attShiftItem = this.attShiftService.getItemById(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("startDate", attShiftItem.getStartDate());
        result.put("tsdIds", attShiftItem.getTimeSlotDetailIds());
        result.put("tsdList", tsdList);
        result.put("result", "success");
        return result;
    }

    public ZKResultMsg getShiftList() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List attShiftList = this.attShiftService.getByCondition(new AttShiftItem());
        for (AttShiftItem attShift : attShiftList) {
            if (attShift.getStartDate() == null) {
                items.add(new SelectItem((Object)attShift.getShiftName(), attShift.getId()));
                continue;
            }
            items.add(new SelectItem((Object)(attShift.getShiftName() + "(" + attShift.getStartDate() + ")"), attShift.getId()));
        }
        return new ZKResultMsg(items);
    }

    public String validNo(String shiftNo) {
        boolean rs = !this.attShiftService.existsByShiftNo(shiftNo);
        return rs + "";
    }

    public String validName(String shiftName) {
        boolean rs = !this.attShiftService.existsByShiftName(shiftName);
        return rs + "";
    }

    @RequiresPermissions(value={"att:shift:clear"})
    public ZKResultMsg clean(String id) {
        this.attShiftService.cleanByShiftIds(id);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:shift:clear"})
    public ZKResultMsg cleanByIds(String id, String idp) {
        this.attShiftService.cleanShiftTimeSolt(id, idp);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid allList(AttShiftSchItem condition) {
        if ("1".equals(condition.getScheduleType())) {
            condition.setShiftType(Short.valueOf((short)0));
        }
        Pager pager = this.attShiftService.getItemsByPage((BaseItem)condition, this.getPageNo(), 100000);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

