/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttRuleRemote;
import com.zkteco.zkbiosecurity.att.service.AttAnnualLeaveReportService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttRuleService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttRuleController
extends BaseController
implements AttRuleRemote {
    @Autowired
    private AttRuleService attRuleService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;
    @Autowired
    private AttAnnualLeaveReportService attAnnualLeaveReportService;

    @RequiresPermissions(value={"att:rule"})
    public ModelAndView index() {
        Map attParams = this.attRuleService.getAttParams();
        if (Objects.isNull(attParams.get("att.baseRule.maxOvertimeType"))) {
            attParams.put("att.baseRule.maxOvertimeType", "notLimited");
        }
        if (Objects.isNull(attParams.get("att.baseRule.maxOvertimeMinutes"))) {
            attParams.put("att.baseRule.maxOvertimeMinutes", "0");
        }
        this.request.setAttribute("attParams", (Object)attParams);
        AttLeaveTypeItem condition = new AttLeaveTypeItem();
        condition.setMark("params");
        List attLeaveTypeItemList = this.attLeaveTypeService.getByCondition(condition);
        this.request.setAttribute("attLeaveTypeItemList", (Object)attLeaveTypeItemList);
        List attAnnualLeaveRuleItemList = new ArrayList();
        if (attParams.containsKey("att.annualLeave.rule")) {
            String ruleStr = (String)attParams.get("att.annualLeave.rule");
            attAnnualLeaveRuleItemList = this.attAnnualLeaveReportService.buildRuleItem(ruleStr);
        }
        this.request.setAttribute("attAnnualLeaveRuleItemList", attAnnualLeaveRuleItemList);
        try {
            SpringContextUtil.getBean((String)"workflowInit");
            this.request.setAttribute("showEmployeeSet", (Object)"true");
        }
        catch (Exception e) {
            this.request.setAttribute("showEmployeeSet", (Object)"false");
        }
        return new ModelAndView("att/rule/attRule");
    }

    @RequiresPermissions(value={"att:rule:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_rule", opType="common_op_edit", opContent="att_rule_baseRuleSet", sysParams={"att.baseRule.signIn", "att.baseRule.shortestMinutes", "att.baseRule.signOut", "att.baseRule.longestMinutes", "att.baseRule.crossDay", "att.baseRule.countOvertime", "att.baseRule.lateAndEarly", "att.baseRule.smartFindClass", "att.baseRule.noSignInCountType", "att.baseRule.noSignInCountLateMinute", "att.baseRule.noSignOffCountType", "att.baseRule.noSignOffCountEarlyMinute", "att.countConvert.decimal", "att.self.loginEntrance"})
    public ZKResultMsg save(@RequestParam Map<String, String> params, AttLeaveTypeItem attLeaveTypeItem) {
        for (AttLeaveTypeItem item : attLeaveTypeItem.getAttLeaveTypeItemList()) {
            this.attLeaveTypeService.saveItem(item);
        }
        this.attAnnualLeaveReportService.buildRuleValue(params);
        this.attRuleService.saveItem(params);
        this.attAnnualLeaveReportService.setAnnualLeaveScheduled(params.get("att.annualLeave.calculateMonth"), params.get("att.annualLeave.calculateDay"));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getParams() {
        Map map = this.attRuleService.getAttParams();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)map));
    }
}

