/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttPointRemote;
import com.zkteco.zkbiosecurity.att.service.AttPointService;
import com.zkteco.zkbiosecurity.att.vo.AttEsdcChannelSelectItem;
import com.zkteco.zkbiosecurity.att.vo.AttPointItem;
import com.zkteco.zkbiosecurity.att.vo.AttPointSelectItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttPointController
extends ExportController
implements AttPointRemote {
    @Autowired
    private AttPointService attPointService;

    @RequiresPermissions(value={"att:point"})
    public ModelAndView index() {
        return new ModelAndView("att/point/attPoint");
    }

    @RequiresPermissions(value={"att:point:edit"})
    public ModelAndView edit(String id) {
        this.request.setAttribute("accModule", (Object)this.attPointService.isExistAcc());
        this.request.setAttribute("parkModule", (Object)this.attPointService.isExistPark());
        this.request.setAttribute("insModule", (Object)this.attPointService.isExistIns());
        this.request.setAttribute("pidModule", (Object)this.attPointService.isExistPid());
        this.request.setAttribute("vmsModule", (Object)this.attPointService.isExistVms());
        this.request.setAttribute("psgModule", (Object)this.attPointService.isExistPsg());
        this.request.setAttribute("ivsModule", (Object)this.attPointService.isExistIvs());
        this.request.setAttribute("esdcModule", (Object)this.attPointService.isExistEsdc());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attPointService.getItemById(id));
        } else {
            this.request.setAttribute("item", (Object)new AttPointItem());
        }
        return new ModelAndView("att/point/editAttPoint");
    }

    @RequiresPermissions(value={"att:point:edit"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_point", opType="common_op_new", vo=AttPointItem.class, service=AttPointService.class)
    public ZKResultMsg save(AttPointItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attPointService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public boolean isExist(@RequestParam(value="pointName") String pointName) {
        return this.attPointService.isExist(pointName);
    }

    public ZKResultMsg checkLicenseCount(String deviceModule) {
        return this.attPointService.checkLicenseCount(deviceModule);
    }

    public TreeItem getAllParkEntranceArea() {
        List items = this.attPointService.getAllParkEntranceArea();
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"att:point:refresh"})
    public DxGrid list(AttPointItem condition) {
        Pager pager = this.attPointService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAttPointList(AttPointSelectItem condition) {
        Pager pager = null;
        if (condition.getType().equals("noSelected")) {
            if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
                condition.setSelectId("-1");
            }
            pager = this.attPointService.loadSelectPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:point:del"})
    @LogRequest(module="att_module", object="att_leftMenu_point", opType="common_op_del", requestParams={"ids"}, opContent="att_common_id")
    public ZKResultMsg delete(String ids) {
        this.attPointService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:point:export"})
    public void export(HttpServletRequest req, HttpServletResponse resp) {
        AttPointItem attPointItem = new AttPointItem();
        this.setConditionValue((BaseItem)attPointItem);
        List list = this.attPointService.getItemData(AttPointItem.class, attPointItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(list, AttPointItem.class);
    }

    public ZKResultMsg getPointModule() {
        return new ZKResultMsg((Object)this.attPointService.getPointModule());
    }

    public DxGrid esdcChannelList(AttEsdcChannelSelectItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
                condition.setSelectId("-1");
            }
            pager = this.attPointService.getEsdcChannelSelectList(condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

