/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.constants.AttCommonSchConstant;
import com.zkteco.zkbiosecurity.att.remote.AttPersonSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttGroupService;
import com.zkteco.zkbiosecurity.att.service.AttPersonSchService;
import com.zkteco.zkbiosecurity.att.vo.AttAllPersonSchItem;
import com.zkteco.zkbiosecurity.att.vo.AttGroupItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonSchItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttPersonSchController
extends ExportController
implements AttPersonSchRemote {
    @Autowired
    private AttPersonSchService attPersonSchService;
    @Autowired
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private AttGroupService attGroupService;

    @RequiresPermissions(value={"att:personsch"})
    public ModelAndView index() {
        return new ModelAndView("att/personSch/attPersonSch");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attPersonSchService.getItemById(id));
        }
        return new ModelAndView("att/personSch/editAttPersonSch");
    }

    public ZKResultMsg save(AttPersonSchItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attPersonSchService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(AttAllPersonSchItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.attPersonSchService.getAllPersonSch(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        this.attPersonSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAttShiftSchJsonByDate() {
        String[] splits;
        String schId = this.request.getParameter("schId");
        String dateSelected = this.request.getParameter("dateSelected");
        String personId = null;
        if (StringUtils.isNotBlank((CharSequence)schId) && "pers".equals((splits = schId.split("_"))[0])) {
            personId = splits[1];
        }
        if (StringUtils.isNotBlank((CharSequence)dateSelected)) {
            return this.attPersonSchService.getAttPersonSchJson(personId, dateSelected);
        }
        return null;
    }

    public ModelAndView attSelectPersonContent() {
        return new ModelAndView("att/personSch/attSelectPersonContent");
    }

    public ModelAndView cycleSch(Short type, String ids) {
        this.setPersOrDeptInfo(type, ids);
        return new ModelAndView("att/personSch/editAttCycleSch");
    }

    public ModelAndView tempSch(Short type, String ids) {
        this.setPersOrDeptInfo(type, ids);
        return new ModelAndView("att/personSch/editAttTempSch");
    }

    public ModelAndView info(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("id", (Object)id);
        }
        return new ModelAndView("att/personSch/attPersonSchInfo");
    }

    @LogRequest(module="att_module", object="att_leftMenu_personSch", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"att:personsch:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String[] conditionAry;
        AttAllPersonSchItem attAllPersonSchItem = new AttAllPersonSchItem();
        String sessionId = request.getSession().getId();
        this.setConditionValue((BaseItem)attAllPersonSchItem);
        String queryCondition = request.getParameter("queryConditions");
        for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
            String[] strAry = condition.split("=", 2);
            String fieldName = strAry[0];
            String fieldValue = strAry[1];
            if ("startDate".equals(fieldName)) {
                attAllPersonSchItem.setStartDate(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
                continue;
            }
            if (!"endDate".equals(fieldName)) continue;
            attAllPersonSchItem.setEndDate(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        }
        Pager pager = this.attPersonSchService.getAllPersonSch(sessionId, attAllPersonSchItem, this.getBeginIndex(), this.getEndIndex() + 1);
        List itemList = pager.getData();
        this.excelExport(itemList, AttPersonSchItem.class);
    }

    private void setPersOrDeptInfo(Short type, String ids) {
        StringBuffer showInfo = new StringBuffer("");
        if (AttCommonSchConstant.SCH_TYPE_PERSON.equals(type)) {
            List persPersonItemList = this.persPersonService.getSimpleItemsByIds(Arrays.asList(ids.split(",")));
            for (PersPersonItem persPersonItem : persPersonItemList) {
                showInfo.append(persPersonItem.getName());
                if (StringUtils.isNotBlank((CharSequence)persPersonItem.getLastName()) && !"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                    showInfo.append(persPersonItem.getLastName());
                }
                showInfo.append("(").append(persPersonItem.getPin()).append(")");
                showInfo.append(";");
            }
        } else if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(type)) {
            List authDepartmentItemList = this.authDepartmentService.getItemsByIds(ids);
            for (AuthDepartmentItem authDepartmentItem : authDepartmentItemList) {
                showInfo.append(authDepartmentItem.getName()).append(";");
            }
        } else if (AttCommonSchConstant.SCH_TYPE_GROUP.equals(type)) {
            List attGroupSchItemList = this.attGroupService.getItemsByIds(ids);
            for (AttGroupItem attGroupItem : attGroupSchItemList) {
                showInfo.append(attGroupItem.getGroupName()).append(";");
            }
        }
        showInfo.deleteCharAt(showInfo.length() - 1);
        this.request.setAttribute("showInfo", (Object)showInfo.toString());
        this.request.setAttribute("type", (Object)type);
        this.request.setAttribute("ids", (Object)ids);
    }
}

