/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttPersonRemote;
import com.zkteco.zkbiosecurity.att.service.AttAreaPersonService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.vo.AttPersonAreaItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonSelectItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttPersonController
extends BaseController
implements AttPersonRemote {
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttAreaPersonService attAreaPersonService;

    @RequiresPermissions(value={"pers:person:attEdit"})
    public ModelAndView edit(@RequestParam(value="personId", required=false) String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.request.setAttribute("item", (Object)this.attPersonService.getItemByPersonId(personId));
            this.request.setAttribute("attPersonAreas", (Object)this.attAreaPersonService.getAreaIdsByPersonId(personId));
        } else {
            this.request.setAttribute("attPersonAreas", (Object)this.attAreaPersonService.getRootAreaId());
        }
        return new ModelAndView("att/person/editAttPerson");
    }

    public DxGrid attPersonList(AttPersonAreaItem condition) {
        SecuritySubject authUser = this.getCurrentSubject();
        if (!authUser.getIsSuperuser().booleanValue() && authUser.getDepartmentIds() != null && authUser.getDepartmentIds().size() > 0) {
            condition.setInDeptId(authUser.getDepartmentIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
        }
        Pager pager = this.attPersonService.getPersonAreaItemsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectList(AttPersonSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.attPersonService.getAttPersonSelectByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid attAreaSelectPerson(AttPersonSelectItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.attPersonService.getNoExistPerson(this.request.getSession().getId(), condition, null, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPersonInfo(String ids) {
        String pin = this.request.getParameter("pin");
        AttPersonItem attPersonItem = this.attPersonService.getByPinFromPersonCache(pin);
        JSONObject jsonObject = new JSONObject();
        if (null != attPersonItem) {
            jsonObject.put("personId", (Object)attPersonItem.getPersonId());
            jsonObject.put("personPin", (Object)attPersonItem.getPersonPin());
            jsonObject.put("personName", (Object)attPersonItem.getPersonName());
            jsonObject.put("personLastName", (Object)attPersonItem.getPersonLastName());
            jsonObject.put("deptName", (Object)attPersonItem.getDeptName());
            jsonObject.put("deptCode", (Object)attPersonItem.getDeptCode());
            jsonObject.put("deptId", (Object)attPersonItem.getDeptId());
        }
        return new ZKResultMsg((Object)jsonObject);
    }
}

