/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttOvertimeRemote;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.vo.AttOvertimeItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttOvertimeController
extends ExportController
implements AttOvertimeRemote {
    @Autowired
    private AttOvertimeService attOvertimeService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:overtime"})
    public ModelAndView index() {
        if (this.getCurrentSubject().getStaff().booleanValue()) {
            this.request.setAttribute("flowType", (Object)"overtime");
            return new ModelAndView("att/flowable/overtime/attOvertime");
        }
        return new ModelAndView("att/overtime/attOvertime");
    }

    @RequiresPermissions(value={"att:overtime:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = this.getCurrentSubject().getStaff();
        AttOvertimeItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attOvertimeService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttOvertimeItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/overtime/editAttOvertime");
    }

    @RequiresPermissions(value={"att:overtime:add"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_new", vo=AttOvertimeItem.class, service=AttOvertimeService.class)
    public ZKResultMsg save(AttOvertimeItem item) {
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        calendar.set(5, 1);
        Date theFirstDayOfLastMonth = DateUtil.getDayBeginTime((Date)calendar.getTime());
        if (theFirstDayOfLastMonth.compareTo(item.getStartDatetime()) > 0) {
            return ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"att_apply_overLastMonth", (Object[])new Object[0]));
        }
        ZKResultMsg res = new ZKResultMsg();
        this.attOvertimeService.saveItem(item, personIds, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:overtime:refresh"})
    public DxGrid list(AttOvertimeItem condition) {
        Pager pager = this.attOvertimeService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:overtime:del"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attOvertimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:overtime:export"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttOvertimeItem attOvertimeItem = new AttOvertimeItem();
        this.setConditionValue((BaseItem)attOvertimeItem);
        List intemList = this.attOvertimeService.getItemData(request.getSession().getId(), attOvertimeItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttOvertimeItem.class);
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("personPin", (Object)"");
        jsonColumn.put("personName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("personLastName", (Object)"");
        }
        jsonColumn.put("startDatetime", (Object)"");
        jsonColumn.put("endDatetime", (Object)"");
        jsonColumn.put("remark", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttOvertimeItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttOvertimeItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttOvertimeItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attOvertimeService.importExcel(itemList, this.request.getSession().getId()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttOverTime Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"att:overtime:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="att_apply_pass", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg approval(String ids) {
        if (this.attOvertimeService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attOvertimeService.approval(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:overtime:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="att_exception_refuse", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg refuse(String ids) {
        if (this.attOvertimeService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attOvertimeService.refuse(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

