/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttMessageCenterRemote;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.service.AttSignService;
import com.zkteco.zkbiosecurity.att.vo.AttAdjustItem;
import com.zkteco.zkbiosecurity.att.vo.AttClassItem;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveItem;
import com.zkteco.zkbiosecurity.att.vo.AttOvertimeItem;
import com.zkteco.zkbiosecurity.att.vo.AttSignItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttMessageCenterController
extends BaseController
implements AttMessageCenterRemote {
    @Autowired
    private AttLeaveService attLeaveService;
    @Autowired
    private AttOvertimeService attOvertimeService;
    @Autowired
    private AttSignService attSignService;
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttClassService attClassService;
    @Autowired
    private PersPersonService persPersonService;

    public ModelAndView info(String id, String type) {
        if ("leave".equals(type)) {
            AttLeaveItem item = this.attLeaveService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            String name = this.buildName(item.getPersonPin());
            item.setPersonName(name);
            this.request.setAttribute("item", (Object)item);
        } else if ("sign".equals(type)) {
            AttSignItem item = this.attSignService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            String name = this.buildName(item.getPersonPin());
            item.setPersonName(name);
            this.request.setAttribute("item", (Object)item);
        } else if ("overtime".equals(type)) {
            AttOvertimeItem item = this.attOvertimeService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            String name = this.buildName(item.getPersonPin());
            item.setPersonName(name);
            this.request.setAttribute("item", (Object)item);
        } else if ("adjust".equals(type)) {
            AttAdjustItem item = this.attAdjustService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            String name = this.buildName(item.getPersonPin());
            item.setPersonName(name);
            this.request.setAttribute("item", (Object)item);
        } else if ("classShift".equals(type)) {
            AttClassItem item = this.attClassService.getItemById(id);
            if (item == null) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_prompt_exception_datanoexists", (Object[])new Object[0]));
            }
            String adjustName = this.buildName(item.getAdjustPersonPin());
            item.setAdjustPersonName(adjustName);
            String swapName = this.buildName(item.getSwapPersonPin());
            item.setSwapPersonName(swapName);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("att/messageCenter/attMessageCenterInfo");
    }

    private String buildName(String pin) {
        String name;
        PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
        if (Objects.isNull(persPersonItem)) {
            return "";
        }
        String personName = persPersonItem.getName();
        String lastName = persPersonItem.getLastName();
        if (StringUtils.isBlank((CharSequence)personName) && StringUtils.isBlank((CharSequence)lastName)) {
            return "";
        }
        String string = name = StringUtils.isNotBlank((CharSequence)personName) ? personName : "";
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            name = StringUtils.isNotBlank((CharSequence)name) ? name + " " + lastName : lastName;
        }
        return name;
    }
}

