/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.bean.AttCalculationParamsBean;
import com.zkteco.zkbiosecurity.att.bean.AttRuleParamBean;
import com.zkteco.zkbiosecurity.att.remote.AttManualCalculationRemote;
import com.zkteco.zkbiosecurity.att.service.Att4PersPersonService;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttCalculateService;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.service.AttHolidayService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.service.AttShiftService;
import com.zkteco.zkbiosecurity.att.service.AttSignService;
import com.zkteco.zkbiosecurity.att.service.AttTimeSlotService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.Att4PersPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttManualCalculationItem;
import com.zkteco.zkbiosecurity.att.vo.AttShiftItem;
import com.zkteco.zkbiosecurity.att.vo.AttTimeSlotItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttManualCalculationController
extends BaseController
implements AttManualCalculationRemote {
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttCalculateService attCalculateService;
    @Autowired
    private Att4PersPersonService att4PersPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttParamService attParamService;
    @Autowired
    private AttHolidayService attHolidayService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;
    @Autowired
    private AttShiftService attShiftService;
    @Autowired
    private AttTimeSlotService attTimeSlotService;
    @Autowired
    private AttSignService attSignService;
    @Autowired
    private AttLeaveService attLeaveService;
    @Autowired
    private AttOvertimeService attOvertimeService;
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttClassService attClassService;
    @Autowired
    private AttRecordService attRecordService;

    @RequiresPermissions(value={"att:manualCalculation"})
    public ModelAndView index() {
        return new ModelAndView("att/manualCalculation/attManualCalculation");
    }

    @RequiresPermissions(value={"att:manualCalculation:refresh"})
    public DxGrid list(AttManualCalculationItem condition) {
        Pager pager = this.attPersonService.getItemsByPageForAttCal(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg calculating() {
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:manualCalculation:calculate"})
    @LogRequest(module="att_module", object="att_op_calculation", opType="att_op_calculation", requestParams={"pins"}, opContent="att_person_pin")
    public void calculate(String personIds, String deptIds, String startDateStr, String endDateStr, String pins, String totalLeaver, String isIncludeLower) {
        try {
            boolean attendanceLeaver;
            this.progressCache.beginProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])));
            int currentProgress = 0;
            int totalProgress = 0;
            Date startDate = AttDateUtils.getMinOfDay((String)startDateStr);
            Date endDate = AttDateUtils.getMaxOfDay((String)endDateStr);
            boolean bl = attendanceLeaver = "true".equals(totalLeaver);
            if (StringUtils.isNotBlank((CharSequence)deptIds) && "true".equals(isIncludeLower)) {
                List authDeptIdAry = this.attPersonService.getAllChildDeptById(deptIds);
                deptIds = StringUtils.join((Object[])authDeptIdAry.toArray(), (String)",");
            }
            List pinList = this.attPersonService.filterPinList(personIds, deptIds, startDate, attendanceLeaver);
            int personTotal = pinList.size();
            this.log.info("Manual calculate personTotal = {}", (Object)personTotal);
            this.progressCache.setProcess(new ProcessBean(10, totalProgress += 10, I18nUtil.i18nCode((String)"att_statistical_filter", (Object[])new Object[0]) + "<br/>"));
            AttRuleParamBean attRuleParamBean = this.attParamService.getRuleParam();
            Set holidaySet = this.attHolidayService.getHolidayDateSet(startDate, endDate);
            List attShiftItems = this.attShiftService.getByCondition(new AttShiftItem());
            Map attShiftItemMap = attShiftItems.stream().collect(Collectors.toMap(AttShiftItem::getId, Function.identity()));
            List attTimeSlotItems = this.attTimeSlotService.getAllTimeSlotItem();
            Map attTimeSlotItemMap = attTimeSlotItems.stream().collect(Collectors.toMap(AttTimeSlotItem::getId, Function.identity()));
            this.progressCache.setProcess(new ProcessBean(10, totalProgress += 10, I18nUtil.i18nCode((String)"att_statistical_initData", (Object[])new Object[0]) + "<br/>"));
            Date dateBefore = DateUtil.getDateBefore((Date)startDate, (int)2);
            Date dateAfter = DateUtil.getDateAfter((Date)endDate, (int)2);
            Map attLeaveMap = this.attLeaveService.getLeaveMap(null, dateBefore, dateAfter);
            Map attOvertimeMap = this.attOvertimeService.getOvertimeMap(null, dateBefore, dateAfter);
            Map attAdjustMap = this.attAdjustService.getAdjustMap(null, startDate, endDate);
            Map attClassMap = this.attClassService.getClassMap(null, startDate, endDate);
            this.progressCache.setProcess(new ProcessBean(10, totalProgress += 10, I18nUtil.i18nCode((String)"att_statistical_exception", (Object[])new Object[0]) + "<br/>"));
            this.progressCache.setProcess(new ProcessBean(0, totalProgress, I18nUtil.i18nCode((String)"att_statistical_begin", (Object[])new Object[0]) + "<br/>"));
            int remainProgress = 100 - totalProgress;
            int batchNum = personTotal % 800 == 0 ? personTotal / 800 : personTotal / 800 + 1;
            int batchIndex = 0;
            int threadCount = Runtime.getRuntime().availableProcessors() / 2 + 1;
            ArrayList<CompletableFuture> completableFutureList = new ArrayList<CompletableFuture>(threadCount);
            this.log.info("Manual calculate threadCount = {}", (Object)threadCount);
            for (int fromIndex = 0; fromIndex < personTotal; fromIndex += 800) {
                int toIndex = Math.min(personTotal, fromIndex + 800);
                this.log.info("Manual calculate fromIndex = {} -> toIndex = {},", (Object)fromIndex, (Object)toIndex);
                if (completableFutureList.size() >= threadCount) {
                    CompletableFuture.anyOf(completableFutureList.toArray(new CompletableFuture[completableFutureList.size()])).join();
                    Iterator iterator = completableFutureList.iterator();
                    while (iterator.hasNext()) {
                        CompletableFuture next = (CompletableFuture)iterator.next();
                        if (!next.isDone()) continue;
                        iterator.remove();
                        currentProgress = 100 * ++batchIndex / batchNum;
                        totalProgress = 100 - remainProgress + remainProgress * batchIndex / batchNum;
                        this.progressCache.setProcess(new ProcessBean(currentProgress, totalProgress, I18nUtil.i18nCode((String)"att_op_calculation", (Object[])new Object[0]) + totalProgress + "%...<br/>"));
                    }
                }
                List subPinList = pinList.subList(fromIndex, toIndex);
                AttCalculationParamsBean calculationParamsBean = new AttCalculationParamsBean();
                calculationParamsBean.setPins(subPinList).setStartDate(startDate).setEndDate(endDate).setAttLeaveMap(attLeaveMap).setAttOvertimeMap(attOvertimeMap).setAttAdjustMap(attAdjustMap).setAttClassMap(attClassMap).setAttRuleParamBean(attRuleParamBean).setAttHolidaySet(holidaySet).setAttShiftItemMap(attShiftItemMap).setAttTimeSlotItemMap(attTimeSlotItemMap);
                CompletableFuture completableFuture = this.attCalculateService.calculateBatchPerson(calculationParamsBean);
                completableFutureList.add(completableFuture);
            }
            while (!completableFutureList.isEmpty()) {
                Iterator iterator = completableFutureList.iterator();
                while (iterator.hasNext()) {
                    CompletableFuture next = (CompletableFuture)iterator.next();
                    if (!next.isDone()) continue;
                    iterator.remove();
                    currentProgress = 100 * ++batchIndex / batchNum;
                    totalProgress = 100 - remainProgress + remainProgress * batchIndex / batchNum;
                    this.progressCache.setProcess(new ProcessBean(currentProgress, totalProgress, I18nUtil.i18nCode((String)"att_op_calculation", (Object[])new Object[0]) + totalProgress + "%...<br/>"));
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.log.info("Manual calculate finish");
            this.progressCache.setProcess(new ProcessBean(100, 100, I18nUtil.i18nCode((String)"att_statistical_end", (Object[])new Object[0]) + "<br/>"));
            this.progressCache.finishProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0])));
        }
        catch (Exception e) {
            this.log.error("Manual calculate error", (Throwable)e);
            this.progressCache.setProcess(new ProcessBean(100, 100, "<span style='color:red;'>" + I18nUtil.i18nCode((String)"att_statistical_error", (Object[])new Object[0]) + "<span><br/>"));
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"att_statistical_end", (Object[])new Object[0]));
        }
    }

    public String getDeptPins(String deptIds) {
        JSONObject jsonObject = new JSONObject();
        List<String> dptIds = Arrays.asList(deptIds.split(","));
        List persPersonItems = this.att4PersPersonService.getPersPersonByDeptIds(dptIds);
        StringBuilder pins = new StringBuilder();
        StringBuilder persIds = new StringBuilder();
        int index = 1;
        for (Att4PersPersonItem persPersonItem : persPersonItems) {
            if (index != persPersonItems.size()) {
                pins.append(persPersonItem.getPersonPin() + ",");
                persIds.append(persPersonItem.getPersonId() + ",");
            } else {
                pins.append(persPersonItem.getPersonPin());
                persIds.append(persPersonItem.getPersonId());
            }
            ++index;
        }
        jsonObject.put("pins", (Object)pins);
        jsonObject.put("persIds", (Object)persIds);
        return jsonObject.toJSONString();
    }
}

