/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttLeaveRemote;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.util.HttpsUtils;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveItem;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttLeaveController
extends ExportController
implements AttLeaveRemote {
    @Autowired
    private AttLeaveService attLeaveService;
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttOvertimeService attOvertimeService;
    @Autowired
    private AttClassService attClassService;
    @Autowired
    private AttParamService attParamService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:leave"})
    public ModelAndView index() {
        if (this.getCurrentSubject().getStaff().booleanValue()) {
            this.request.setAttribute("flowType", (Object)"leave");
            return new ModelAndView("att/flowable/leave/attLeave");
        }
        return new ModelAndView("att/leave/attLeave");
    }

    @RequiresPermissions(value={"att:leave:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttLeaveItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attLeaveService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttLeaveItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        this.request.setAttribute("tripAndOutId", (Object)this.attLeaveTypeService.getTripAndOutId());
        return new ModelAndView("att/leave/editAttLeave");
    }

    public ModelAndView viewLeavePhoto(String key) {
        this.request.setAttribute("key", (Object)key);
        return new ModelAndView("att/flowable/leave/leavePhoto");
    }

    @RequiresPermissions(value={"att:leave:add"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_new", vo=AttLeaveItem.class, service=AttLeaveService.class)
    public ZKResultMsg save(AttLeaveItem item, @RequestParam(value="leaveImage", required=false) MultipartFile[] files) {
        String personIds = this.request.getParameter("personIds");
        StringBuffer leaveImageBuf = new StringBuffer("");
        if (Objects.nonNull(files) && files.length > 0) {
            for (MultipartFile uploadFile : files) {
                if (uploadFile.isEmpty()) continue;
                String filename = System.currentTimeMillis() + ".jpg";
                String leaveImageStr = FileUtils.saveFileToServer((String)"att", (String)"leave/image", (String)filename, (MultipartFile)uploadFile);
                FileEncryptUtil.encryptFileByPath((String)leaveImageStr);
                String thumbPic = leaveImageStr.replaceFirst(filename, "") + "thumb" + "/" + filename;
                FileEncryptUtil.encryptFileByPath((String)thumbPic);
                leaveImageBuf.append(leaveImageStr.replaceAll("\\\\", "/")).append(",");
            }
            if (leaveImageBuf.length() > 0) {
                leaveImageBuf.deleteCharAt(leaveImageBuf.length() - 1);
            }
        }
        item.setLeaveImagePath(leaveImageBuf.toString());
        this.attLeaveService.saveItem(personIds, item, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:leave:refresh"})
    public DxGrid list(AttLeaveItem condition) {
        this.buildCondition(condition, this.request);
        Pager pager = this.attLeaveService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:leave:del"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attLeaveService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:leave:export"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttLeaveItem attLeaveItem = new AttLeaveItem();
        this.setConditionValue((BaseItem)attLeaveItem);
        this.buildCondition(attLeaveItem, request);
        List intemList = this.attLeaveService.getItemData(request.getSession().getId(), attLeaveItem, this.getBeginIndex(), this.getEndIndex());
        for (AttLeaveItem attLeave : intemList) {
            float leaveLongHour = (float)attLeave.getLeaveLong().intValue() / 60.0f;
            double result = new BigDecimal(leaveLongHour).setScale(1, 4).doubleValue();
            attLeave.setLeaveLongHour(String.valueOf(result));
        }
        this.excelExport(intemList, AttLeaveItem.class);
    }

    private void buildCondition(AttLeaveItem condition, HttpServletRequest request) {
        String flowType = request.getParameter("flowType");
        if (StringUtils.isNotBlank((CharSequence)flowType)) {
            if ("trip".equals(flowType)) {
                condition.setLeaveTypeNo("trip");
            } else if ("out".equals(flowType)) {
                condition.setLeaveTypeNo("out");
            } else {
                condition.setNotInLeaveTypeNo("trip,out");
            }
        }
    }

    public ModelAndView showImage(String id) {
        AttLeaveItem attLeaveItem = this.attLeaveService.getItemById(id);
        String leaveImage = StringUtils.defaultString((String)attLeaveItem.getLeaveImagePath(), (String)"");
        this.request.setAttribute("leaveImage", (Object)leaveImage);
        return new ModelAndView("att/leave/leaveImage");
    }

    public ZKResultMsg calLeaveTime() {
        String personId = this.request.getParameter("personId");
        String startDateTimeStr = this.request.getParameter("startDateTime");
        String endDateTimeStr = this.request.getParameter("endDateTime");
        String leaveTypeId = this.request.getParameter("leaveTypeId");
        AttLeaveTypeItem attLeaveTypeItem = new AttLeaveTypeItem();
        if (StringUtils.isNotBlank((CharSequence)leaveTypeId)) {
            attLeaveTypeItem = this.attLeaveTypeService.getItemById(leaveTypeId);
        } else {
            attLeaveTypeItem.setConvertCount(Double.valueOf(1.0));
            attLeaveTypeItem.setConvertType("abort");
            attLeaveTypeItem.setConvertUnit("minute");
        }
        Date startDateTime = DateUtil.stringToDate((String)startDateTimeStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date endDateTime = DateUtil.stringToDate((String)endDateTimeStr, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
        int minute = this.attLeaveService.calLeaveTimeMinutes(personId, startDateTime, endDateTime, attLeaveTypeItem);
        String hour = this.attParamService.minutesToHourFormat(new BigDecimal(minute));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("minute", (Object)minute);
        jsonObject.put("hour", (Object)hour);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)jsonObject));
    }

    public ZKResultMsg existApply(String personIds, Date startTime, Date endTime, String exceptionType, String leaveTypeId) {
        return this.attLeaveService.existApply(personIds, startTime, endTime);
    }

    public ZKResultMsg existAdjustOrClassApply(String adjustPersonId, Date adjustDate, String swapPersonId, Date swapDate) {
        if (this.attAdjustService.existAdjust(Arrays.asList(adjustPersonId.split(",")), adjustDate, adjustDate)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_adjustTips", (Object[])new Object[0]));
        }
        if (this.attClassService.existApply(adjustPersonId, adjustDate, swapPersonId, swapDate)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_apply_classTips", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("personPin", (Object)"");
        jsonColumn.put("personName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("personLastName", (Object)"");
        }
        jsonColumn.put("leaveTypeName", (Object)"");
        jsonColumn.put("startDatetime", (Object)"");
        jsonColumn.put("endDatetime", (Object)"");
        jsonColumn.put("remark", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttLeaveItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttLeaveItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttLeaveItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attLeaveService.importExcel(itemList, this.request.getSession().getId()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttSign Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"att:leave:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="att_apply_pass", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg approval(String ids) {
        if (this.attLeaveService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attLeaveService.approval(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:leave:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_leave", opType="att_exception_refuse", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg refuse(String ids) {
        if (this.attLeaveService.hasStaffApply(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"att_approve_withoutPermissionApproval"));
        }
        this.attLeaveService.refuse(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLeaveImage() {
        block15: {
            ByteArrayOutputStream out = null;
            HttpURLConnection httpUrl = null;
            InputStream is = null;
            byte[] bytes = new byte[1024];
            try {
                String url = this.request.getParameter("url");
                if (!StringUtils.isNotBlank((CharSequence)url)) break block15;
                if (!url.startsWith("http") && !url.startsWith("https")) {
                    String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)url);
                    bytes = Base64.getDecoder().decode(decryptFileBase64);
                } else if (url.startsWith("https")) {
                    bytes = HttpsUtils.doGet(url);
                } else if (url.startsWith("http")) {
                    URL photoUrl = new URL(url);
                    try {
                        httpUrl = (HttpURLConnection)photoUrl.openConnection();
                        httpUrl.setConnectTimeout(3000);
                        httpUrl.connect();
                        is = httpUrl.getInputStream();
                        if (is != null) {
                            out = new ByteArrayOutputStream();
                            int len = 0;
                            while ((len = is.read(bytes)) != -1) {
                                out.write(bytes, 0, len);
                            }
                            bytes = out.toByteArray();
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        if (httpUrl != null) {
                            httpUrl.disconnect();
                        }
                    }
                }
                this.response.reset();
                this.response.getOutputStream().write(bytes);
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    public ZKResultMsg getImageUrl(String id) {
        AttLeaveItem attLeaveItem = this.attLeaveService.getItemById(id);
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (attLeaveItem != null && StringUtils.isNotBlank((CharSequence)attLeaveItem.getLeaveImagePath())) {
            resultMsg.setRet("ok");
            resultMsg.setData((Object)attLeaveItem.getLeaveImagePath());
        } else {
            resultMsg.setRet("fail");
            resultMsg.setMsg(I18nUtil.i18nCode((String)"att_leave_imageShow", (Object[])new Object[0]));
        }
        return resultMsg;
    }
}

