/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.constants.AttCommonSchConstant;
import com.zkteco.zkbiosecurity.att.remote.AttCycleSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttCycleSchService;
import com.zkteco.zkbiosecurity.att.service.AttGroupService;
import com.zkteco.zkbiosecurity.att.vo.AttCycleSchItem;
import com.zkteco.zkbiosecurity.att.vo.AttGroupItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttCycleSchController
extends ExportController
implements AttCycleSchRemote {
    @Autowired
    private AttCycleSchService attCycleSchService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AttGroupService attGroupService;

    public DxGrid list(AttCycleSchItem condition) {
        Pager pager = this.attCycleSchService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttCycleSchItem attCycleSchItem = this.attCycleSchService.getItemById(id);
            this.request.setAttribute("item", (Object)attCycleSchItem);
            this.request.setAttribute("type", (Object)attCycleSchItem.getCycleType());
            this.setShowInfo(attCycleSchItem);
        }
        return new ModelAndView("att/personSch/editAttCycleSch");
    }

    private void setShowInfo(AttCycleSchItem attCycleSchItem) {
        if (AttCommonSchConstant.SCH_TYPE_PERSON.equals(attCycleSchItem.getCycleType())) {
            PersPersonItem personItem = this.persPersonService.getSimpleItemById(attCycleSchItem.getPersonId());
            if (personItem != null) {
                this.request.setAttribute("showInfo", (Object)(personItem.getName() + "(" + personItem.getPin() + ")"));
            }
        } else if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(attCycleSchItem.getCycleType())) {
            AuthDepartmentItem authDepartmentItem = this.authDepartmentService.getItemById(attCycleSchItem.getDeptId());
            this.request.setAttribute("showInfo", (Object)authDepartmentItem.getName());
        } else if (AttCommonSchConstant.SCH_TYPE_GROUP.equals(attCycleSchItem.getCycleType())) {
            AttGroupItem attGroupItem = this.attGroupService.getItemById(attCycleSchItem.getGroupId());
            this.request.setAttribute("showInfo", (Object)attGroupItem.getGroupName());
        }
    }

    @RequiresPermissions(value={"att:personsch:cycleSch"})
    @LogChangeRequest(module="att_module", object="att_personSch_sch", opType="att_personSch_cycleSch", vo=AttCycleSchItem.class, service=AttCycleSchService.class)
    public ZKResultMsg save(AttCycleSchItem item) {
        String addIds = this.request.getParameter("addIds");
        if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(item.getCycleType())) {
            addIds = this.includeLowerDept(addIds);
        }
        this.attCycleSchService.saveItem(addIds, item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:schDetails:del"})
    @LogRequest(module="att_module", object="att_leftMenu_schDetails", opType="att_personSch_delSch", requestParams={"names"}, opContent="att_personSch_delSch")
    public ZKResultMsg delete(String ids) {
        this.attCycleSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:personsch:cleanCycleSch"})
    @LogRequest(module="att_module", object="att_personSch_sch", opType="att_personSch_cleanCycleSch", requestParams={"names"}, opContent="att_personSch_cleanCycleSch")
    public ZKResultMsg delCycleSch(String ids, Short type, Date startDate, Date endDate) {
        if (AttCommonSchConstant.SCH_TYPE_DEPT.equals(type)) {
            ids = this.includeLowerDept(ids);
        }
        this.attCycleSchService.delCycleSch(ids, type, startDate, endDate);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private String includeLowerDept(String ids) {
        String includeLower = this.request.getParameter("includeLower");
        if ("true".equals(includeLower)) {
            List departmentItems = this.authDepartmentService.getChildDeptItemsByDeptIds(ids);
            ids = Optional.ofNullable(departmentItems).filter(l -> !l.isEmpty()).map(l -> l.stream().map(AuthDepartmentItem::getId).filter(Objects::nonNull).map(String::valueOf).distinct().collect(Collectors.joining(","))).orElse(null);
        }
        return ids;
    }

    @RequiresPermissions(value={"att:schDetails:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String[] conditionAry;
        AttCycleSchItem attCycleSchItem = new AttCycleSchItem();
        this.setConditionValue((BaseItem)attCycleSchItem);
        String queryCondition = request.getParameter("queryConditions");
        for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
            if (!StringUtils.isNotBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=", 2);
            String fieldName = strAry[0];
            String fieldValue = strAry[1];
            if ("startTime".equals(fieldName)) {
                attCycleSchItem.setStartTime(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
                continue;
            }
            if (!"endTime".equals(fieldName)) continue;
            attCycleSchItem.setEndTime(DateUtil.stringToDate((String)fieldValue, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        }
        List attCycleSchItemList = this.attCycleSchService.getItemData(request.getSession().getId(), attCycleSchItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(attCycleSchItemList, AttCycleSchItem.class);
    }
}

