/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttCustomReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttCustomReportService;
import com.zkteco.zkbiosecurity.att.service.AttDayDetailReportService;
import com.zkteco.zkbiosecurity.att.service.AttDeptStatisticalReportService;
import com.zkteco.zkbiosecurity.att.service.AttMonthStatisticalReportService;
import com.zkteco.zkbiosecurity.att.vo.AttCustomReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttDayDetailReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttDeptStatisticalReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttMonthStatisticalReportItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseCustomReportService;
import com.zkteco.zkbiosecurity.system.vo.BaseCustomReportFieldItem;
import com.zkteco.zkbiosecurity.system.vo.BaseCustomReportItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttCustomReportController
extends BaseController
implements AttCustomReportRemote {
    @Autowired
    private AttCustomReportService attCustomReportService;
    @Autowired
    private BaseCustomReportService baseCustomReportService;
    @Autowired
    private AttDayDetailReportService attDayDetailReportService;
    @Autowired
    private AttMonthStatisticalReportService attMonthStatisticalReportService;
    @Autowired
    private AttDeptStatisticalReportService attDeptStatisticalReportService;

    @RequiresPermissions(value={"att:customReport"})
    public ModelAndView index() {
        return new ModelAndView("att/customReport/attCustomReport");
    }

    @RequiresPermissions(value={"att:customReport:add"})
    public ModelAndView edit(String id) {
        BaseCustomReportItem baseCustomReportItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            baseCustomReportItem = this.baseCustomReportService.getItemById(id);
        }
        if (baseCustomReportItem == null) {
            baseCustomReportItem = new BaseCustomReportItem();
            baseCustomReportItem.setModuleCode("att");
        }
        this.request.setAttribute("item", (Object)baseCustomReportItem);
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AttDayDetailReport", I18nUtil.i18nCode((String)"att_customReport_byDayDetail", (Object[])new Object[0]));
        map.put("AttMonthStatisticalReport", I18nUtil.i18nCode((String)"att_customReport_byPerson", (Object[])new Object[0]));
        map.put("AttDeptStatisticalReport", I18nUtil.i18nCode((String)"att_customReport_byDept", (Object[])new Object[0]));
        for (Map.Entry entry : map.entrySet()) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue((String)entry.getKey());
            selectItem.setText(entry.getValue());
            selectItemList.add(selectItem);
        }
        this.request.setAttribute("types", selectItemList);
        this.request.setAttribute("actionUrl", (Object)"attCustomReport.do?save");
        this.request.setAttribute("customReportFieldUrl", (Object)"attCustomReport.do?getCustomReportField");
        return new ModelAndView("system/customReport/editBaseCustomReport");
    }

    @RequiresPermissions(value={"att:customReport:add"})
    @LogRequest(module="att_module", object="att_customReport", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AttCustomReportItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attCustomReportService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:customReport:refresh"})
    public DxGrid list(AttCustomReportItem condition) {
        Pager pager = this.attCustomReportService.getItemsByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:customReport:del"})
    @LogRequest(module="att_module", object="att_customReport", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.baseCustomReportService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg getCustomReportField(String id, String type) {
        HashMap resultMap = new HashMap();
        List selectedFields = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            BaseCustomReportItem baseCustomReportItem = this.baseCustomReportService.getItemById(id);
            selectedFields = baseCustomReportItem.getCustomReportFieldItemList();
        }
        resultMap.put("selectedFields", selectedFields);
        List baseCustomReportFieldItemList = new ArrayList();
        if ("AttDayDetailReport".equals(type)) {
            baseCustomReportFieldItemList = this.baseCustomReportService.getCustomReportFieldByItem(AttDayDetailReportItem.class);
        } else if ("AttDeptStatisticalReport".equals(type)) {
            baseCustomReportFieldItemList = this.baseCustomReportService.getCustomReportFieldByItem(AttDeptStatisticalReportItem.class);
        } else if ("AttMonthStatisticalReport".equals(type)) {
            baseCustomReportFieldItemList = this.baseCustomReportService.getCustomReportFieldByItem(AttMonthStatisticalReportItem.class);
        }
        for (BaseCustomReportFieldItem selectedField : selectedFields) {
            Iterator iterator = baseCustomReportFieldItemList.iterator();
            while (iterator.hasNext()) {
                BaseCustomReportFieldItem baseCustomReportFieldItem = (BaseCustomReportFieldItem)iterator.next();
                if (!baseCustomReportFieldItem.getFieldName().equals(selectedField.getFieldName())) continue;
                iterator.remove();
            }
        }
        resultMap.put("fields", baseCustomReportFieldItemList);
        return new ZKResultMsg(resultMap);
    }

    public ModelAndView toCustomReport(String id) {
        BaseCustomReportItem baseCustomReportItem = this.baseCustomReportService.getItemById(id);
        String path = "att/customReport/attDayDetailReportEx";
        if (baseCustomReportItem != null) {
            String reportType = baseCustomReportItem.getReportType();
            List customReportFieldItemList = baseCustomReportItem.getCustomReportFieldItemList();
            if (customReportFieldItemList != null) {
                List newCustomReportFieldItemList = new ArrayList();
                if ("AttDayDetailReport".equals(reportType)) {
                    this.attDayDetailReportService.modifyItemLabel(AttDayDetailReportItem.class);
                    newCustomReportFieldItemList = this.baseCustomReportService.buildGridColumnByReportField(customReportFieldItemList, AttDayDetailReportItem.class);
                    path = "att/customReport/attDayDetailReportEx";
                } else if ("AttDeptStatisticalReport".equals(reportType)) {
                    this.attDeptStatisticalReportService.modifyItemLabel();
                    newCustomReportFieldItemList = this.baseCustomReportService.buildGridColumnByReportField(customReportFieldItemList, AttDeptStatisticalReportItem.class);
                    path = "att/customReport/attDeptStatisticalReportEx";
                } else if ("AttMonthStatisticalReport".equals(reportType)) {
                    this.attMonthStatisticalReportService.modifyItemLabel();
                    newCustomReportFieldItemList = this.baseCustomReportService.buildGridColumnByReportField(customReportFieldItemList, AttMonthStatisticalReportItem.class);
                    path = "att/customReport/attMonthStatisticalReportEx";
                }
                String showColumns = newCustomReportFieldItemList.stream().map(BaseCustomReportFieldItem::getFieldName).collect(Collectors.joining(","));
                this.request.setAttribute("showColumns", (Object)showColumns);
            }
        }
        return new ModelAndView(path);
    }
}

