/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttClassRemote;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.vo.AttClassItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttClassController
extends ExportController
implements AttClassRemote {
    @Autowired
    private AttClassService attClassService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:class"})
    public ModelAndView index() {
        if (this.getCurrentSubject().getStaff().booleanValue()) {
            return new ModelAndView("att/flowable/classShift/attClassShift");
        }
        return new ModelAndView("att/class/attClass");
    }

    @RequiresPermissions(value={"att:class:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttClassItem item = new AttClassItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attClassService.getItemById(id);
        } else if (staff == null || !staff.booleanValue()) {
            item.setFlowStatus("2");
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/class/editAttClass");
    }

    @RequiresPermissions(value={"att:class:add"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_class", opType="common_op_new", vo=AttClassItem.class, service=AttClassService.class)
    public ZKResultMsg save(AttClassItem item) {
        ZKResultMsg res = this.attClassService.saveItem(item, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:class:refresh"})
    public DxGrid list(AttClassItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.attClassService.loadPagerByAuthUserFilter(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:class:del"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attClassService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:class:export"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttClassItem attClassItem = new AttClassItem();
        this.setConditionValue((BaseItem)attClassItem);
        List intemList = this.attClassService.getItemData(request.getSession().getId(), attClassItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttClassItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttClassItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttClassItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attClassService.importExcel(itemList, this.request.getSession().getId()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttClass Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("adjustPersonPin", (Object)"");
        jsonColumn.put("adjustPersonName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("adjustPersonLastName", (Object)"");
        }
        jsonColumn.put("adjustDeptName", (Object)"");
        jsonColumn.put("adjustType", (Object)"");
        jsonColumn.put("adjustDate", (Object)"");
        jsonColumn.put("swapShiftName", (Object)"");
        jsonColumn.put("swapPersonPin", (Object)"");
        jsonColumn.put("swapPersonName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("swapPersonLastName", (Object)"");
        }
        jsonColumn.put("swapDeptName", (Object)"");
        jsonColumn.put("swapDate", (Object)"");
        jsonColumn.put("remark", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttClassItem.class, jsonCloumnMap);
    }

    @RequiresPermissions(value={"att:class:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="att_apply_pass", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg approval(String ids) {
        this.attClassService.approval(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:class:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="att_exception_refuse", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg refuse(String ids) {
        this.attClassService.refuse(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

