/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttAutoExportRemote;
import com.zkteco.zkbiosecurity.att.service.AttAutoExportService;
import com.zkteco.zkbiosecurity.att.vo.AttAutoExportItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAutoExportController
extends BaseController
implements AttAutoExportRemote {
    @Autowired
    private AttAutoExportService attAutoExportService;

    @RequiresPermissions(value={"att:autoExport"})
    public ModelAndView index() {
        return new ModelAndView("att/autoExport/attAutoExport");
    }

    @RequiresPermissions(value={"att:autoExport:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attAutoExportService.getItemById(id));
        }
        if (this.attAutoExportService.completeMailInfo()) {
            this.request.setAttribute("isSetSystemMailParam", (Object)"true");
        } else {
            this.request.setAttribute("isSetSystemMailParam", (Object)"false");
        }
        return new ModelAndView("att/autoExport/editAttAutoExport");
    }

    @RequiresPermissions(value={"att:autoExport:edit"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_autoExport", opType="common_op_edit", vo=AttAutoExportItem.class, service=AttAutoExportService.class)
    public ZKResultMsg save(AttAutoExportItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getFtpPassword())) {
            item.setFtpPassword(new String(Base64Util.decode((String)item.getFtpPassword())));
        }
        this.attAutoExportService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:autoExport:refresh"})
    public DxGrid list(AttAutoExportItem condition) {
        Pager pager = this.attAutoExportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:autoExport:del"})
    @LogRequest(module="att_module", object="att_leftMenu_autoExport", opType="common_op_del", requestParams={"ids"}, opContent="att_common_id")
    public ZKResultMsg delete(String ids) {
        this.attAutoExportService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:autoExport:enable"})
    public ZKResultMsg enable(String ids) {
        this.attAutoExportService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:autoExport:disable"})
    public ZKResultMsg disable(String ids) {
        this.attAutoExportService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg ftpTest(String ftpUrl, int ftpPort, String ftpUsername, String ftpPassword) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        try {
            ftpPassword = new String(Base64Util.decode((String)ftpPassword));
            boolean b = this.attAutoExportService.ftpTest(ftpUrl, ftpPort, ftpUsername, ftpPassword);
            if (!b) {
                zkResultMsg.setRet("fail");
                zkResultMsg.setMsg("att_autoExport_ftpFail");
            } else {
                zkResultMsg.setMsg("att_autoExport_ftpSuccess");
            }
        }
        catch (Exception e) {
            this.log.error("exception = ", (Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

