/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttAreaPersonRemote;
import com.zkteco.zkbiosecurity.att.service.AttAreaPersonService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.vo.AttAreaPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttAuthAreaItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAreaPersonController
extends ExportController
implements AttAreaPersonRemote {
    @Autowired
    private AttAreaPersonService attAreaPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    public DxGrid authAreaList(AttAuthAreaItem authAreaItem) {
        SecuritySubject authUser = this.getCurrentSubject();
        if (!authUser.getIsSuperuser().booleanValue() && authUser.getAreaIds() != null && authUser.getDepartmentIds().size() > 0) {
            authAreaItem.setAuthAreaIdIn(authUser.getAreaIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
        }
        Pager pager = this.attAreaPersonService.authAreaList(authAreaItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, authAreaItem.getClass());
    }

    @RequiresPermissions(value={"att:areaPerson"})
    public ModelAndView index() {
        return new ModelAndView("att/areaPerson/attAreaPerson");
    }

    @RequiresPermissions(value={"att:areaPerson:refresh"})
    public DxGrid list(AttAreaPersonItem condition) {
        Pager pager = this.attAreaPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:areaPerson:del"})
    @LogRequest(module="att_module", object="att_op_forZoneAddPers", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.attAreaPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:areaPerson:setUserSms"})
    public ModelAndView setUserSms(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("att/areaPerson/setUserSms");
    }

    public ZKResultMsg addSms(String ids) {
        String startTime = this.request.getParameter("startTime");
        String msg = this.request.getParameter("msg");
        String min = this.request.getParameter("min");
        ZKResultMsg zKResultMsg = this.attAreaPersonService.addSms(ids, startTime, msg, min);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:areaPerson:syncPerToDev"})
    public ZKResultMsg syncPerToDev(String areaId, String ids) {
        ZKResultMsg res = this.attAreaPersonService.syncPerToDev(areaId, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:areaPerson:addPerson"})
    @LogRequest(module="att_module", object="att_op_forZoneAddPers", opType="common_op_new", requestParams={"personIds"}, opContent="att_areaPerson_personId")
    public ZKResultMsg addPerson() {
        String personIds = this.request.getParameter("personIds");
        String areaId = this.request.getParameter("areaId");
        ZKResultMsg res = this.attAreaPersonService.addPerson(personIds, areaId, "-1");
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:areaPerson:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttAreaPersonItem attAreaPersonItem = new AttAreaPersonItem();
        this.setConditionValue((BaseItem)attAreaPersonItem);
        List itemList = this.attAreaPersonService.loadListByAuthFilter(attAreaPersonItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, AttAreaPersonItem.class);
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("pin", (Object)"");
        jsonColumn.put("name", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("lastName", (Object)"");
        }
        jsonColumn.put("deptCode", (Object)"");
        jsonColumn.put("deptName", (Object)"");
        jsonColumn.put("authAreaNo", (Object)"");
        jsonColumn.put("authAreaName", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttAreaPersonItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttAreaPersonItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttAreaPersonItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attAreaPersonService.importAreaPerson(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importBatchDel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttAreaPersonItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttAreaPersonItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attAreaPersonService.importBatchDel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

