/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttAnnualLeaveReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttAnnualLeaveReportService;
import com.zkteco.zkbiosecurity.att.vo.AttAnnualLeaveReportItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAnnualLeaveReportController
extends ExportController
implements AttAnnualLeaveReportRemote {
    @Autowired
    private AttAnnualLeaveReportService attAnnualLeaveReportService;

    @RequiresPermissions(value={"att:annualLeaveReport"})
    public ModelAndView index() {
        return new ModelAndView("att/report/attAnnualLeaveReport");
    }

    @RequiresPermissions(value={"att:annualLeaveReport:refresh"})
    public DxGrid list(AttAnnualLeaveReportItem condition) {
        Pager pager = this.attAnnualLeaveReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:annualLeaveReport:export"})
    @LogRequest(module="att_module", object="att_annualLeave_report", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttAnnualLeaveReportItem attAnnualLeaveReportItem = new AttAnnualLeaveReportItem();
        this.setConditionValue((BaseItem)attAnnualLeaveReportItem);
        List intemList = this.attAnnualLeaveReportService.getItemData(request.getSession().getId(), attAnnualLeaveReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttAnnualLeaveReportItem.class);
    }

    public ZKResultMsg getDetail(String personId) {
        return this.attAnnualLeaveReportService.getDetail(personId);
    }

    public ZKResultMsg recalculate(String ids, String type) {
        return this.attAnnualLeaveReportService.recalculate(ids, type);
    }

    public ModelAndView adjustView(String ids, String type) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("type", (Object)type);
        return new ModelAndView("att/report/attAnnealLeaveAdjust");
    }

    public ZKResultMsg adjust(String ids, Integer adjustDays, String type) {
        return this.attAnnualLeaveReportService.adjust(ids, adjustDays, type);
    }
}

