/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttAdjustRemote;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttShiftService;
import com.zkteco.zkbiosecurity.att.util.AttExcelUtil;
import com.zkteco.zkbiosecurity.att.util.AttImportWithRowNumUtil;
import com.zkteco.zkbiosecurity.att.vo.AttAdjustItem;
import com.zkteco.zkbiosecurity.att.vo.AttShiftItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAdjustController
extends ExportController
implements AttAdjustRemote {
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttShiftService attShiftService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttExcelUtil attExcelUtil;

    @RequiresPermissions(value={"att:adjust"})
    public ModelAndView index() {
        if (this.getCurrentSubject().getStaff().booleanValue()) {
            return new ModelAndView("att/flowable/adjust/attAdjust");
        }
        return new ModelAndView("att/adjust/attAdjust");
    }

    @RequiresPermissions(value={"att:adjust:add"})
    public ModelAndView edit(String id) {
        AttAdjustItem item = this.attAdjustService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        List shiftItemList = this.attShiftService.getByCondition(new AttShiftItem());
        if (shiftItemList != null && shiftItemList.size() > 0) {
            this.request.setAttribute("attShiftId", (Object)((AttShiftItem)shiftItemList.get(0)).getId());
        }
        return new ModelAndView("att/adjust/editAttAdjust");
    }

    @RequiresPermissions(value={"att:adjust:add"})
    @LogChangeRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_new", vo=AttAdjustItem.class, service=AttAdjustService.class)
    public ZKResultMsg save(AttAdjustItem item) {
        String personIds = this.request.getParameter("personIds");
        ZKResultMsg res = this.attAdjustService.saveItem(item, personIds, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:adjust:refresh"})
    public DxGrid list(AttAdjustItem condition) {
        Pager pager = this.attAdjustService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:adjust:del"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attAdjustService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:adjust:export"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttAdjustItem attAdjustItem = new AttAdjustItem();
        this.setConditionValue((BaseItem)attAdjustItem);
        List intemList = this.attAdjustService.getItemData(request.getSession().getId(), AttAdjustItem.class, attAdjustItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttAdjustItem.class);
    }

    public void importTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("personPin", (Object)"");
        jsonColumn.put("personName", (Object)"");
        if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
            jsonColumn.put("personLastName", (Object)"");
        }
        jsonColumn.put("adjustDate", (Object)"");
        jsonColumn.put("remark", (Object)"");
        HashMap<String, Map<String, String>> jsonCloumnMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        this.attExcelUtil.attExcelExport(request, response, new ArrayList(), AttAdjustItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<AttAdjustItem> itemList = AttImportWithRowNumUtil.excelImport(upload.getInputStream(), AttAdjustItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attAdjustService.importExcel(itemList, this.request.getSession().getId()));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import AttAdjust Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"att:adjust:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="att_apply_pass", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg approval(String ids) {
        this.attAdjustService.approval(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"att:adjust:approval"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="att_exception_refuse", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg refuse(String ids) {
        this.attAdjustService.refuse(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

