/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.service.AttAppService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v1"})
public class AttAppController {
    @Autowired
    private AttAppService attAppService;

    @RequestMapping(value={"/monthlyStatistics"}, method={RequestMethod.POST})
    public JSONObject monthlyStatistics(@RequestBody JSONObject jsonObject) {
        String pin = jsonObject.getString("pin");
        String date = jsonObject.getString("date");
        String[] dateArray = date.split("-");
        int year = Integer.parseInt(dateArray[0]);
        int month = Integer.parseInt(dateArray[1]);
        Date startDate = AttDateUtils.getFirstDayOfMonth((int)year, (int)month);
        Date endDate = AttDateUtils.getLastDayOfMonth((int)year, (int)month);
        return this.attAppService.monthlyStatistics(pin, startDate, endDate);
    }

    @RequestMapping(value={"/monthlyAttendanceCalendar"}, method={RequestMethod.POST})
    public AppResultMessage monthlyAttendanceCalendar(@RequestBody JSONObject jsonObject) {
        String pin = jsonObject.getString("pin");
        String date = jsonObject.getString("time");
        return this.attAppService.getAttendanceCalendar(pin, date);
    }
}

