/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.zkteco.zkbiosecurity.att.service.AttPersonSchDataService;
import com.zkteco.zkbiosecurity.att.service.AttPersonSchService;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/personSch"})
public class AttApiPersonSchController {
    @Autowired
    private AttPersonSchService attPersonSchService;
    @Autowired
    private AttPersonSchDataService attPersonSchDataService;

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getPersonSch"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getPersonSch(@RequestBody ZKMessage message) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map dataMap = message.getContent();
        String pin = MapUtils.getString((Map)dataMap, (Object)"pin");
        String startDate = MapUtils.getString((Map)dataMap, (Object)"startDate");
        String endDate = MapUtils.getString((Map)dataMap, (Object)"endDate");
        if (StringUtils.isNotBlank((CharSequence)pin) && StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            List attCloudPersonSchItems = this.attPersonSchService.getAttCalendarForApp(pin, startDate, endDate);
            resultMsg.setData((Object)attCloudPersonSchItems);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getTodayWorkTime"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTodayWorkTime(@RequestBody ZKMessage message) {
        Map content = message.getContent();
        String pin = MapUtils.getString((Map)content, (Object)"pin");
        String attDate = MapUtils.getString((Map)content, (Object)"attDate");
        ZKResultMsg zkResultMsg = this.attPersonSchDataService.getTodayWorkTime(pin, attDate);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

