/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AttApiPersonItem;
import com.zkteco.zkbiosecurity.att.service.AttApiService;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/attPerson"})
@Api(tags={"AttPerson"}, description="att person")
public class AttApiPersonController {
    private static final Logger log = LoggerFactory.getLogger(AttApiPersonController.class);
    @Autowired
    private AttApiService attApiService;

    @ResponseBody
    @RequestMapping(value={"/editAttPerson"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Edit AttPerson", notes="Edit AttPerson", response=ApiResultMessage.class)
    public ApiResultMessage editAttPerson(@RequestBody AttApiPersonItem attApiPersonItem) {
        if (StringUtils.isBlank((CharSequence)attApiPersonItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (attApiPersonItem.getIsAttendance() == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"isAttendance"}));
        }
        if (attApiPersonItem.getPerDevAuth() == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"perDevAuth"}));
        }
        if (attApiPersonItem.getVerifyMode() == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"verifyMode"}));
        }
        return this.attApiService.editAttPerson(attApiPersonItem);
    }
}

