/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.service.AttAnnualLeaveReportService;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/attLaveHoliday"})
public class AttApiLaveHolidayController {
    @Autowired
    private AttAnnualLeaveReportService attAnnualLeaveReportService;

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getLeaveLaveHoliday"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLeaveLaveHoliday(@RequestBody ZKMessage zkMessage) {
        Map content = zkMessage.getContent();
        String personPin = MapUtils.getString((Map)content, (Object)"personPin");
        ZKResultMsg resultMsg = this.attAnnualLeaveReportService.getDetailByPersonPin(personPin);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(path={"/getOvertimeTypeList"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOvertimeTypeList(@RequestBody ZKMessage zkMessage) {
        JSONArray overtimeTypeArray = new JSONArray();
        JSONObject normal = new JSONObject();
        normal.put("code", (Object)"0");
        normal.put("value", (Object)I18nUtil.i18nCode((String)"att_overtime_normal", (Object[])new Object[0]));
        overtimeTypeArray.add((Object)normal);
        JSONObject rest = new JSONObject();
        rest.put("code", (Object)"1");
        rest.put("value", (Object)I18nUtil.i18nCode((String)"att_overtime_rest", (Object[])new Object[0]));
        overtimeTypeArray.add((Object)rest);
        JSONObject holiday = new JSONObject();
        holiday.put("code", (Object)"2");
        holiday.put("value", (Object)I18nUtil.i18nCode((String)"att_shift_holidayOt", (Object[])new Object[0]));
        overtimeTypeArray.add((Object)holiday);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)overtimeTypeArray));
    }
}

