/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AttApiAreaItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiAreaPersonItem;
import com.zkteco.zkbiosecurity.att.service.AttAreaPersonService;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/attAreaPerson"})
@Api(tags={"AttAreaPerson"}, description="att area person")
public class AttApiAreaPersonController {
    private static final Logger log = LoggerFactory.getLogger(AttApiAreaPersonController.class);
    @Autowired
    private AttAreaPersonService attAreaPersonService;

    @ApiOperation(value="Get Area List", notes="Return Area List", response=ApiResultMessage.class)
    @RequestMapping(value={"/area/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage listArea(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List apiBaseAreas = this.attAreaPersonService.getApiAreaList(pageNo.intValue(), pageSize.intValue());
        return ApiResultMessage.successMessage((Object)apiBaseAreas);
    }

    @ApiOperation(value="Get Area By Code", notes="Return Area", response=ApiResultMessage.class)
    @RequestMapping(value={"/area/get/{code}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getArea(@PathVariable String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return ApiResultMessage.message((int)-83, (String)I18nUtil.i18nCode((String)"att_api_areaCodeNotNull", (Object[])new Object[0]));
        }
        AttApiAreaItem attApiAreaItem = this.attAreaPersonService.getApiAreaByCode(code);
        return ApiResultMessage.successMessage((Object)attApiAreaItem);
    }

    @ApiOperation(value="Set Area Person", notes="Set Area Person", response=ApiResultMessage.class)
    @RequestMapping(value={"/set"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage setAreaPerson(@RequestBody AttApiAreaPersonItem areaPerson) {
        ApiResultMessage rs = null;
        try {
            rs = this.attAreaPersonService.addApiAreaPerson(areaPerson);
        }
        catch (Exception e) {
            log.error("api attAreaPerson/set error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Delete Area Person", notes="Delete Area Person", response=ApiResultMessage.class)
    public ApiResultMessage delAreaPerson(@RequestBody AttApiAreaPersonItem areaPerson) {
        ApiResultMessage rs = null;
        try {
            rs = this.attAreaPersonService.delApiAreaPerson(areaPerson);
        }
        catch (Exception e) {
            log.error("api attAreaPerson/delete error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

