/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplyLeaveImageItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplyLeaveItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplyOvertimeItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplySignItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplyTimeLongItem;
import com.zkteco.zkbiosecurity.att.service.AttApiService;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/attApply"})
@Api(tags={"AttApply"}, description="att apply")
public class AttApiApplyController {
    private static final Logger log = LoggerFactory.getLogger(AttApiApplyController.class);
    @Autowired
    private AttApiService attApiService;

    @ResponseBody
    @RequestMapping(value={"/getApplyTimeLong"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Apply Time", notes="Apply Time", response=ApiResultMessage.class)
    public ApiResultMessage getApplyTimeLong(@RequestBody AttApiApplyTimeLongItem attApiApplyTimeLongItem) {
        if (StringUtils.isBlank((CharSequence)attApiApplyTimeLongItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyTimeLongItem.getLeaveTypeNo())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"leaveTypeNo"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyTimeLongItem.getStartDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"startDatetime"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyTimeLongItem.getEndDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"endDatetime"}));
        }
        if (attApiApplyTimeLongItem.getStartDatetime().compareTo(attApiApplyTimeLongItem.getEndDatetime()) >= 0) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_startDateGeEndDate", (Object[])new Object[0]));
        }
        return this.attApiService.getApplyTimeLong(attApiApplyTimeLongItem);
    }

    @ApiOperation(value="Get LeaveType List", notes="Get LeaveType List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getLeaveTypeList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getLeaveTypeList() {
        return this.attApiService.getLeaveTypeList();
    }

    @ResponseBody
    @RequestMapping(value={"/applySign"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Apply Sign", notes="Apply Sign", response=ApiResultMessage.class)
    public ApiResultMessage applySign(@RequestBody AttApiApplySignItem attApiApplySignItem) {
        if (StringUtils.isBlank((CharSequence)attApiApplySignItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplySignItem.getSignDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"signDatetime"}));
        }
        return this.attApiService.applySign(attApiApplySignItem);
    }

    @ResponseBody
    @RequestMapping(value={"/applyOvertime"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Apply Overtime", notes="Apply Overtime", response=ApiResultMessage.class)
    public ApiResultMessage applyOvertime(@RequestBody AttApiApplyOvertimeItem attApiApplyOvertimeItem) {
        if (StringUtils.isBlank((CharSequence)attApiApplyOvertimeItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyOvertimeItem.getStartDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"startDatetime"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyOvertimeItem.getEndDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"endDatetime"}));
        }
        if (attApiApplyOvertimeItem.getStartDatetime().compareTo(attApiApplyOvertimeItem.getEndDatetime()) >= 0) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_startDateGeEndDate", (Object[])new Object[0]));
        }
        return this.attApiService.applyOvertime(attApiApplyOvertimeItem);
    }

    @ResponseBody
    @RequestMapping(value={"/applyLeave"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Apply Leave", notes="Apply Leave", response=ApiResultMessage.class)
    public ApiResultMessage applyLeave(@RequestBody AttApiApplyLeaveItem attApiApplyLeaveItem) {
        if (StringUtils.isBlank((CharSequence)attApiApplyLeaveItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyLeaveItem.getLeaveTypeNo())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"leaveTypeNo"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyLeaveItem.getStartDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"startDatetime"}));
        }
        if (StringUtils.isBlank((CharSequence)attApiApplyLeaveItem.getEndDatetime())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"endDatetime"}));
        }
        if (attApiApplyLeaveItem.getStartDatetime().compareTo(attApiApplyLeaveItem.getEndDatetime()) >= 0) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_startDateGeEndDate", (Object[])new Object[0]));
        }
        String leaveImagePath = attApiApplyLeaveItem.getLeaveImagePath();
        if (StringUtils.isNotBlank((CharSequence)leaveImagePath)) {
            if (leaveImagePath.split(",").length > 4) {
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_leave_maxFileCount", (Object[])new Object[0]));
            }
            if (leaveImagePath.length() > 2000) {
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_imageLengthNot2000", (Object[])new Object[0]));
            }
        }
        return this.attApiService.applyLeave(attApiApplyLeaveItem);
    }

    @ApiOperation(value="Upload Leave Image", notes="Upload Leave Image", response=ApiResultMessage.class)
    @RequestMapping(value={"/uploadLeaveImage"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage uploadLeaveImage(@RequestBody AttApiApplyLeaveImageItem attApiApplyLeaveImageItem) {
        if (StringUtils.isBlank((CharSequence)attApiApplyLeaveImageItem.getBase64Image())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"att_api_notNull", (Object[])new Object[]{"base64Image"}));
        }
        return this.attApiService.uploadLeaveImage(attApiApplyLeaveImageItem);
    }
}

