/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccVerifyModeRulePersonGroupRemote;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccVerifyModeRuleService;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonVerifyModeRuleItem;
import com.zkteco.zkbiosecurity.acc.vo.AccVerifyModeRulePersonGroupItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccVerifyModeRulePersonGroupController
extends BaseController
implements AccVerifyModeRulePersonGroupRemote {
    @Autowired
    private AccVerifyModeRuleService accVerifyModeRuleService;
    @Autowired
    private AccPersonService accPersonService;

    @RequiresPermissions(value={"acc:verifyModeRulePersonGroup"})
    public ModelAndView index() {
        return new ModelAndView("acc/verifyModeRulePersonGroup/accVerifyModeRulePersonGroup");
    }

    @RequiresPermissions(value={"acc:verifyModeRulePersonGroup:refresh"})
    public DxGrid list(AccVerifyModeRulePersonGroupItem codition) {
        Pager pager = this.accVerifyModeRuleService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:verifyModeRulePersonGroup:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRulePersonGroup", opType="pers_common_addPerson", requestParams={"verifyModeRuleName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String verifyModeRulePersonGroupId, String personIds, String deptIds) {
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)verifyModeRulePersonGroupId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList<String> personIdList = new ArrayList<String>(Arrays.asList(personIds.split(",")));
            List existPersonIds = this.accVerifyModeRuleService.getExistPersonIds();
            if (existPersonIds.size() > 0) {
                personIdList.removeAll(existPersonIds);
            }
            this.accVerifyModeRuleService.addPerson(verifyModeRulePersonGroupId, personIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:verifyModeRulePersonGroup:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRulePersonGroup", opType="pers_common_delPerson", requestParams={"verifyModeRuleName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String verifyModeRulePersonGroupId, String personIds) {
        this.accVerifyModeRuleService.delPerson(verifyModeRulePersonGroupId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:verifyModeRulePersonGroup:refresh"})
    public DxGrid personList(AccPersonVerifyModeRuleItem condition) {
        Pager pager = this.accPersonService.getPersonVerifyModeRuleItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

