/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccVerifyModeRuleRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.service.AccVerifyModeRuleService;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorVerifyModeRuleItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTimeSegItem;
import com.zkteco.zkbiosecurity.acc.vo.AccVerifyModeRuleItem;
import com.zkteco.zkbiosecurity.acc.vo.AccVerifyModeRuleSelectDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccVerifyModeRuleController
extends BaseController
implements AccVerifyModeRuleRemote {
    @Autowired
    private AccVerifyModeRuleService accVerifyModeRuleService;
    @Autowired
    private AccTimeSegService accTimeSegService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccDeviceService accDeviceService;

    @RequiresPermissions(value={"acc:verifyModeRule"})
    public ModelAndView index() {
        return new ModelAndView("acc/verifyModeRule/accVerifyModeRule");
    }

    @RequiresPermissions(value={"acc:verifyModeRule:add", "acc:verifyModeRule:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccVerifyModeRuleItem item = this.accVerifyModeRuleService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("newVerifyMode", (Object)(item.getNewVerifyMode() != null && item.getNewVerifyMode() == 1 ? 1 : 0));
        } else {
            this.request.setAttribute("newVerifyMode", (Object)0);
        }
        return new ModelAndView("acc/verifyModeRule/editAccVerifyModeRule");
    }

    @RequiresPermissions(value={"acc:verifyModeRule:add", "acc:verifyModeRule:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRule", opType="common_op_edit", requestParams={"name"}, opContent="acc_common_ruleName")
    public ZKResultMsg save(AccVerifyModeRuleItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accVerifyModeRuleService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:verifyModeRule:refresh"})
    public DxGrid list(AccVerifyModeRuleItem codition) {
        Pager pager = this.accVerifyModeRuleService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:verifyModeRule:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRule", opType="common_op_del", requestParams={"names"}, opContent="acc_common_ruleName")
    public ZKResultMsg del(String ids) {
        this.accVerifyModeRuleService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccVerifyModeRuleItem item = this.accVerifyModeRuleService.getItemByName(name);
        boolean rs = item == null;
        return String.valueOf(rs);
    }

    public ZKResultMsg getTimeSegJSONWithoutRule(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = "-1";
        }
        ZKResultMsg zkResultMsg = this.accVerifyModeRuleService.getTimeSegJSONWithoutRule(id);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getTimeSegById(String id) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        AccTimeSegItem accTimeSegItem = this.accTimeSegService.getItemById(id);
        zkResultMsg.setData((Object)accTimeSegItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getVerifyMode() {
        ZKResultMsg zkResultMsg = this.accVerifyModeRuleService.getVerifyMode();
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:verifyModeRule:refresh"})
    public DxGrid doorList(AccDoorVerifyModeRuleItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accDoorService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:verifyModeRule:addDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRule", opType="acc_map_addDoor", requestParams={"verifyModeRuleName", "doorNames"}, opContent="acc_door_name")
    public ZKResultMsg addDoor(String verifyModeRuleId, String doorIds) {
        if (StringUtils.isNotBlank((CharSequence)verifyModeRuleId) && StringUtils.isNotBlank((CharSequence)doorIds)) {
            ArrayList<String> doorIdList = new ArrayList<String>(Arrays.asList(doorIds.split(",")));
            this.accVerifyModeRuleService.addDoor(verifyModeRuleId, doorIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:verifyModeRule:delDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_verifyModeRule", opType="acc_level_doorDelete", requestParams={"verifyModeRuleName", "doorNames"}, opContent="acc_door_name")
    public ZKResultMsg delDoor(String verifyModeRuleId, String doorIds) {
        this.accVerifyModeRuleService.delDoor(verifyModeRuleId, doorIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectDoorlist(AccVerifyModeRuleSelectDoorItem condition) {
        String verifyModeRuleId = condition.getVerifyModeRuleId();
        String filterDoorIds = this.accVerifyModeRuleService.getFilterDoorId(verifyModeRuleId);
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            if (StringUtils.isNotBlank((CharSequence)filterDoorIds)) {
                condition.setSelectId(String.valueOf(condition.getSelectId()) + "," + filterDoorIds);
            }
            condition.setSelectDoorIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectDoorIdsIn(condition.getSelectId());
        }
        condition.setFilterId(verifyModeRuleId);
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        condition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accDoorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getTimeSegListWithoutRule(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = "-1";
        }
        return new ZKResultMsg((Object)this.accVerifyModeRuleService.getTimeSegListWithoutRule(id));
    }
}

