/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccTransactionRemote;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccParamService;
import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionCardNoItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionPhotoItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccTransactionController
extends ExportController
implements AccTransactionRemote {
    @Autowired
    private AccTransactionService accTransactionService;
    @Autowired
    private AccParamService accParamService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private AccLevelService accLevelService;

    @RequiresPermissions(value={"acc:transaction"})
    public ModelAndView index() {
        return new ModelAndView("acc/transaction/accTransaction");
    }

    @RequiresPermissions(value={"acc:transaction:refresh"})
    public DxGrid list(AccTransactionItem condition) {
        Pager pager = this.accTransactionService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"acc:transaction:refresh"})
    public ZKResultMsg listByApp(String pin, String doorId, int pageNo, int pageSize) {
        AccTransactionItem condition = new AccTransactionItem();
        condition.setPin(pin);
        condition.setEventPointId(doorId);
        Pager pager = this.accTransactionService.getItemsByPage((BaseItem)condition, pageNo, pageSize);
        ZKResultMsg msg = new ZKResultMsg((Object)pager.getData());
        return msg;
    }

    @RequiresPermissions(value={"acc:transaction:del"})
    public ZKResultMsg del(String ids) {
        this.accTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:transaction:del"})
    @LogRequest(module="acc_module", object="common_leftMenu_transaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.accTransactionService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:transaction:export"})
    @LogRequest(module="acc_module", object="common_leftMenu_transaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccTransactionItem accTransactionItem = new AccTransactionItem();
        this.setConditionValue((BaseItem)accTransactionItem);
        accTransactionItem.setAreaNameIn(this.accTransactionService.getAreaNamesBySessionId(request.getSession().getId()));
        accTransactionItem.setDeptCodeIn(this.accTransactionService.getDeptCodesBySessionId(request.getSession().getId()));
        List itemList = this.accTransactionService.getItemData(AccTransactionItem.class, (BaseItem)accTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccTransactionItem.class);
    }

    public ZKResultMsg isFileExist(String vidLinkageHandle) {
        boolean isExist = this.accTransactionService.isFileExist(vidLinkageHandle);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)String.valueOf(isExist)));
    }

    @RequiresPermissions(value={"acc:rtMonitor:transactionTodayHappen"})
    public DxGrid getTransactionsTodayLast(AccTransactionItem accTransactionItem) {
        accTransactionItem.setStartTime(DateUtil.getTodayBeginTime());
        accTransactionItem.setEndTime(DateUtil.getTodayEndTime());
        Pager pager = this.accTransactionService.getTransactionsTodayLast(accTransactionItem);
        return GridUtil.convert((Pager)pager, accTransactionItem.getClass());
    }

    public ZKResultMsg readerCardNo(String readerIds, String type, Date time) {
        if (Objects.isNull(time)) {
            time = new Date();
        }
        List item = this.accTransactionService.getCurrIssueCardNoByReader(readerIds, time);
        HashMap<String, String> map = new HashMap<String, String>();
        String cardNo = "";
        if (!CollectionUtils.isEmpty((Collection)item)) {
            JSONObject identityCardInfo;
            cardNo = ((AccTransactionCardNoItem)item.get(0)).getCardNo();
            if ("IDCard".equals(type) && (identityCardInfo = this.accTransactionService.getIdentityCardInfo(cardNo)) != null && identityCardInfo.containsKey((Object)"data")) {
                JSONArray jsonArray = identityCardInfo.getJSONArray("data");
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                map.put("identityCardInfo", jsonObject.toJSONString());
            }
        }
        map.put("cardNo", cardNo);
        map.put("time", DateUtil.dateToString((Date)time, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(map));
    }

    public ZKResultMsg viewVidLinkData(String vidLinkageHandle, String fileType) {
        return this.accTransactionService.viewVidLinkData(vidLinkageHandle, fileType);
    }

    public ZKResultMsg getVideoFile(String id) {
        Map retMap = this.accTransactionService.getVideoFileValidate(id);
        if (Objects.nonNull(retMap)) {
            ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
            if (ret != null) {
                return I18nUtil.i18nMsg((ZKResultMsg)ret);
            }
            String filePath = retMap.get("filePath").toString();
            File file = (File)retMap.get("file");
            int index = filePath.lastIndexOf(File.separator);
            String fileName = filePath.substring(index + 1);
            if (file.isDirectory() && file.listFiles().length > 0) {
                File childFile = file.listFiles()[0];
                fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
            }
            this.response.setCharacterEncoding("utf-8");
            this.response.setContentType("multipart/form-data");
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            try {
                int length;
                FileInputStream inputStream = new FileInputStream(filePath);
                ServletOutputStream os = this.response.getOutputStream();
                byte[] b = new byte[2048];
                while ((length = ((InputStream)inputStream).read(b)) > 0) {
                    os.write(b, 0, length);
                }
                os.close();
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    @RequiresPermissions(value={"acc:transaction:exportPhoto"})
    public void exportPhoto() throws Exception {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        try {
            String tempPath;
            File zipTempFile;
            String isEncrypt;
            boolean isMSIE;
            String fileNamePrefix;
            String startDate = this.request.getParameter("startDate");
            String endDate = this.request.getParameter("endDate");
            String deviceSns = this.request.getParameter("deviceSns");
            AccTransactionPhotoItem condition = new AccTransactionPhotoItem();
            condition.setStartTime(DateUtil.stringToDate((String)startDate, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            condition.setEndTime(DateUtil.stringToDate((String)endDate, (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            condition.setInDeviceSn(deviceSns);
            List accTransactionPhotoItems = this.accTransactionService.getPhotoFilePathList(this.request.getSession().getId(), condition);
            String name = fileNamePrefix = I18nUtil.i18nCode((String)"acc_trans_photo", (Object[])new Object[0]);
            ArrayList<AccTransactionPhotoItem> photoFileItems = new ArrayList<AccTransactionPhotoItem>();
            Long fileSizeTotal = 0L;
            for (AccTransactionPhotoItem item : accTransactionPhotoItems) {
                File file = new File(FileUtils.getLocalFullPath((String)item.getCapturePhotoPath()));
                if (!file.exists()) continue;
                item.setCapturePhotoPath(file.getAbsolutePath());
                photoFileItems.add(item);
                fileSizeTotal = fileSizeTotal + file.length();
            }
            if (photoFileItems.size() == 0) {
                throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
            }
            if (fileSizeTotal > 0x40000000L || photoFileItems.size() > 10000) {
                throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"acc_trans_fileIsTooLarge", (Object[])new Object[0]), (Object[])new Object[0]);
            }
            String agent = this.request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
            } else {
                fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                fileNamePrefix = fileNamePrefix.replace("%2520", " ");
            }
            if (StringUtils.isNotBlank((CharSequence)(isEncrypt = this.request.getParameter("isEncrypt"))) && !"1".equals(isEncrypt)) {
                name = fileNamePrefix;
            }
            if (!(zipTempFile = new File(tempPath = String.valueOf((String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtils.systemFilePath + File.separator + "upload" + File.separator + "event").replace("/", File.separator)) + File.separator + name + "_" + DateUtil.dateToString((Date)condition.getStartTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + "_" + DateUtil.dateToString((Date)condition.getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + ".zip")).exists()) {
                zipTempFile.createNewFile();
            }
            String tempDecryptPath = "/upload/event/photo" + File.separator + "export_decrypt";
            this.response.reset();
            FileOutputStream fileOutputStream = new FileOutputStream(zipTempFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            try {
                for (AccTransactionPhotoItem item : photoFileItems) {
                    File file = new File(item.getCapturePhotoPath());
                    String fileName = file.getName();
                    ZipEntry zipEntry = new ZipEntry(String.valueOf(item.getCompressDirectory()) + fileName);
                    String photoPath = item.getCapturePhotoPath().substring(item.getCapturePhotoPath().indexOf(String.valueOf(File.separator) + "upload"));
                    byte[] decPhoto = FileEncryptUtil.getDecryptFile((String)photoPath);
                    if (Objects.nonNull(decPhoto)) {
                        String decryFilePath = FileEncryptUtil.saveByte2File((String)(String.valueOf(tempDecryptPath) + File.separator + fileName), (byte[])decPhoto);
                        file = new File(FileUtils.getLocalFullPath((String)decryFilePath));
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 512);
                    zipOutputStream.putNextEntry(zipEntry);
                    try {
                        int index;
                        byte[] buffer = new byte[512];
                        while ((index = bufferedInputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, index);
                        }
                    }
                    finally {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                }
            }
            finally {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)isEncrypt) && "1".equals(isEncrypt)) {
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(zipTempFile);
                    String zipPath = String.valueOf((String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtils.systemFilePath + File.separator + "upload").replace("/", File.separator)) + File.separator + fileNamePrefix + "_" + DateUtil.dateToString((Date)condition.getStartTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + "_" + DateUtil.dateToString((Date)condition.getEndTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + ".zip";
                    FileUtil.fileEncryptZip((String)zipPath, files, (String)this.request.getParameter("encryptPassword"), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
                    File file = new File(zipPath);
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    FileUtils.downloadZip((File)zipTempFile, (HttpServletResponse)this.response);
                }
                this.response.flushBuffer();
            }
            finally {
                if (zipTempFile.exists()) {
                    zipTempFile.delete();
                }
                FileUtil.deleteDirectory((String)FileUtil.getLocalFullPath((String)tempDecryptPath));
            }
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
        }
    }

    public ZKResultMsg getDigifortVideoFile(String cameraName, long eventTime) {
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        ZKResultMsg ret = this.accTransactionService.getDigifortVideoFile(cameraName, eventTime);
        String filePath = "";
        if (ret.getData() == null) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            return ZKResultMsg.failMsg((String)ret.getMsg(), (Object[])new Object[0]);
        }
        filePath = (String)ret.getData();
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            return ZKResultMsg.failMsg();
        }
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        this.response.setCharacterEncoding("utf-8");
        this.response.setContentType("multipart/form-data");
        this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try {
            int length;
            FileInputStream inputStream = new FileInputStream(filePath);
            ServletOutputStream os = this.response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = ((InputStream)inputStream).read(b)) > 0) {
                os.write(b, 0, length);
            }
            os.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        return null;
    }

    public ZKResultMsg getDecryptPhotoBase64(String photoPath) {
        String decryptPhoto;
        if (StringUtils.isNotBlank((CharSequence)photoPath) && StringUtils.isNotBlank((CharSequence)(decryptPhoto = this.accParamService.getDecryptBase64ByCapturePhotoPath(photoPath)))) {
            return new ZKResultMsg((Object)("data:image/jpg;base64," + decryptPhoto));
        }
        return ZKResultMsg.failMsg();
    }
}

