/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccTransactionByPersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionPersonDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccTransactionByPersonController
extends ExportController
implements AccTransactionByPersonRemote {
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccDoorService accDoorService;

    @RequiresPermissions(value={"acc:transactionByPerson"})
    public ModelAndView index() {
        return new ModelAndView("acc/transactionByPerson/accTransactionByPerson");
    }

    @RequiresPermissions(value={"acc:transactionByPerson:refresh"})
    public DxGrid list(AccTransactionPersonItem condition) {
        Pager pager = this.accPersonService.getAccTransactionPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:transactionByPerson:refresh"})
    public DxGrid doorList(AccTransactionPersonDoorItem condition) {
        Pager pager = this.accDoorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:transactionByPerson:export"})
    @LogRequest(module="acc_module", object="common_leftMenu_searchByPerson", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String personId = request.getParameter("personId");
        AccTransactionPersonDoorItem accTransactionPersonDoorItem = new AccTransactionPersonDoorItem();
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            accTransactionPersonDoorItem.setPersonId(personId);
        }
        List itemList = this.accDoorService.getPersonDoorItemData(AccTransactionPersonDoorItem.class, (BaseItem)accTransactionPersonDoorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccTransactionPersonDoorItem.class);
    }
}

