/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccReaderRemote;
import com.zkteco.zkbiosecurity.acc.service.AccChannelService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccReaderOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccReaderService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceOptionItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccReaderItem;
import com.zkteco.zkbiosecurity.acc.vo.AccReaderOptionItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSelectReaderItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSelectReaderRadioItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccReaderController
extends BaseController
implements AccReaderRemote {
    @Autowired
    private AccReaderService accReaderService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;
    @Autowired
    private AccReaderOptionService accReaderOptionService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccChannelService accChannelService;

    @RequiresPermissions(value={"acc:reader"})
    public ModelAndView index() {
        return new ModelAndView("acc/reader/accReader");
    }

    @RequiresPermissions(value={"acc:reader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            boolean cardControl;
            AccReaderOptionItem readMode;
            AccReaderOptionItem readerModel;
            AccReaderItem accReaderItem;
            AccReaderOptionItem infoReveal = this.accReaderOptionService.getByOptName((accReaderItem = this.accReaderService.getItemById(id)).getId(), "IsSupportInfoReveal");
            accReaderItem.setUserInfoReveal(infoReveal != null ? infoReveal.getValue() : "0");
            this.request.setAttribute("item", (Object)accReaderItem);
            AccDoorItem accDoorItem = this.accDoorService.getItemById(accReaderItem.getDoorId());
            String deviceSn = accDoorItem.getDeviceSn();
            String ext485ReaderFunOn = this.accDeviceOptionService.getOptVal(deviceSn, "~Ext485ReaderFunOn");
            if (StringUtils.isBlank((CharSequence)ext485ReaderFunOn) || ext485ReaderFunOn.equals("0")) {
                this.request.setAttribute("noSupportRS485", (Object)true);
            }
            this.request.setAttribute("isSupportConfig", (Object)this.accDeviceOptionService.isSupportFunList(deviceSn, 18));
            this.request.setAttribute("isSupportWgOrRS485", (Object)this.accDeviceOptionService.isSupportFunList(deviceSn, 32));
            AccDeviceOptionItem devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(deviceSn, "SupportReaderType");
            if (devOpt != null) {
                this.request.setAttribute("supportReaderType", (Object)devOpt.getValue());
            }
            if (this.accDeviceOptionService.isSupportFunList(deviceSn, 0)) {
                this.request.setAttribute("readerDisable", (Object)true);
            }
            if (this.accDeviceOptionService.isSupportFunList(deviceSn, 1)) {
                this.request.setAttribute("encrypt", (Object)true);
            }
            if ((readerModel = this.accReaderOptionService.getByOptName(accReaderItem.getId(), "ReaderModel")) != null) {
                this.request.setAttribute("readerModel", (Object)readerModel.getValue());
            }
            if ((readMode = this.accReaderOptionService.getByOptName(accReaderItem.getId(), "IdentityCardVerifyMode")) != null) {
                this.request.setAttribute("readMode", (Object)readMode.getValue());
            }
            if (cardControl = this.accReaderService.checkCardControl()) {
                this.request.setAttribute("requireCardControl", (Object)true);
            }
            if (StringUtils.isNotBlank((CharSequence)accReaderItem.getExtDevId())) {
                this.request.setAttribute("extBoard", (Object)true);
            }
            if (this.accDeviceOptionService.isSupportFunList(deviceSn, 49)) {
                this.request.setAttribute("supportOSDP", (Object)true);
            }
            this.request.setAttribute("isSupportUserLockFun", (Object)this.accDeviceOptionService.isSupportFunList(deviceSn, 50));
            this.request.setAttribute("isSupportInfoReveal", (Object)this.accDeviceOptionService.isSupportFunList(deviceSn, 51));
            int lockCount = Integer.parseInt(this.accDeviceOptionService.getOptVal(deviceSn, "LockCount"));
            this.request.setAttribute("lockCount", (Object)lockCount);
        }
        return new ModelAndView("acc/reader/editAccReader");
    }

    @RequiresPermissions(value={"acc:reader:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_reader", opType="common_op_edit", requestParams={"name"}, opContent="acc_readerDefine_readerName")
    public ZKResultMsg save(AccReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String applyTo = this.request.getParameter("applyTo");
        String readMode = this.request.getParameter("readMode");
        if (StringUtils.isBlank((CharSequence)applyTo)) {
            applyTo = "";
        }
        item.setIdCardMode(readMode);
        this.accReaderService.saveItem(item, applyTo);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:reader:refresh"})
    public DxGrid list(AccReaderItem condition) {
        Pager pager = this.accReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:reader:del"})
    public ZKResultMsg del(String ids) {
        this.accReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(AccReaderItem item) {
        return this.accReaderService.isExist(item.getName());
    }

    public boolean isExistVid() {
        return this.accReaderService.isExistVid();
    }

    public boolean isExistIP(AccReaderItem item) {
        return this.accReaderService.isExistIP(item.getIp());
    }

    public boolean readerCommAddressExist(AccReaderItem item) {
        return this.accReaderService.readerCommAddressExist(item);
    }

    public DxGrid getWGReaderFilterList(AccSelectReaderRadioItem condition) {
        Pager pager = this.accReaderService.getWGReaderFilterListByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, AccSelectReaderRadioItem.class);
    }

    public DxGrid selectReaderList(AccSelectReaderItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(condition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accReaderService.getSelectItemByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectReaderBindAiDeviceList(AccSelectReaderRadioItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(condition.getSelectId());
        }
        Pager pager = this.accReaderService.selectReaderBindAiDeviceList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getTcpReaderFilterList(AccSelectReaderRadioItem condition) {
        Pager pager = this.accReaderService.getTcpReaderFilterList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, AccSelectReaderRadioItem.class);
    }

    public ZKResultMsg startReaderIDCard() {
        String readerId = this.request.getParameter("readerId");
        String result = "-1";
        if (StringUtils.isNotBlank((CharSequence)readerId)) {
            result = this.accReaderService.startReaderIDCard(readerId);
        }
        return new ZKResultMsg((Object)result);
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"AccReader");
        String channel2EntityIds = this.accChannelService.getBindChannelIds(Arrays.asList(entityId), "AccReader");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("acc/reader/accReaderSelectChannelContent");
    }

    @RequiresPermissions(value={"acc:reader:bindChannel"})
    @LogRequest(module="acc_module", object="common_leftMenu_reader", opType="common_vid_bindOrUnbindChannel", requestParams={}, opContent="common_vid_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.accChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

