/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccRTMonitorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAuxInService;
import com.zkteco.zkbiosecurity.acc.service.AccAuxOutService;
import com.zkteco.zkbiosecurity.acc.service.AccBaseDictionaryService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccParamService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.vo.AccRTMonitorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccRTMonitorController
extends ExportController
implements AccRTMonitorRemote {
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccAuxInService accAuxInService;
    @Autowired
    private AccAuxOutService accAuxOutService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccBaseDictionaryService accBaseDictionaryService;
    @Autowired
    private AccParamService accParamService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private AccLevelService accLevelService;

    @RequiresPermissions(value={"acc:rtMonitor", "acc:rtMonitor:browse"})
    public ModelAndView index() {
        String loadPlugins = (String)this.accParamService.getVidParams().get("vid.loadPlugins");
        String accIsShowPhoto = this.accParamService.getParamValByName("acc.isShowPhoto");
        String accIsShowSound = this.accParamService.getParamValByName("acc.isShowSound");
        String personPhotoMaxHeight = this.accParamService.getParamValByName("acc.personPhotoMaxHeight");
        boolean isEnableCardNoEncrypt = this.persParamsService.getEncryptPropByParamName("pers.cardNo.encryptProp");
        this.request.setAttribute("accIsShowPhoto", (Object)accIsShowPhoto);
        this.request.setAttribute("accIsShowSound", (Object)accIsShowSound);
        this.request.setAttribute("personPhotoMaxHeight", (Object)personPhotoMaxHeight);
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        this.request.setAttribute("isEnableCardNoEncrypt", (Object)isEnableCardNoEncrypt);
        return new ModelAndView("acc/rtMonitor/accRTMonitor");
    }

    public DxGrid list(AccRTMonitorItem codition) {
        return null;
    }

    public List getAllDoor() {
        ArrayList data = new ArrayList();
        ZKResultMsg resultMsg = this.accDoorService.getDoorStatus(this.request.getSession().getId(), I18nUtil.i18nCode((String)"common_paging_loading", (Object[])new Object[0]));
        JSONArray doorStates = (JSONArray)resultMsg.getData();
        if (Objects.nonNull(doorStates) && doorStates.size() > 0) {
            doorStates.forEach(door -> {
                boolean bl = data.add(door);
            });
        }
        return data;
    }

    public List getAllAuxIn() {
        ArrayList data = new ArrayList();
        ZKResultMsg resultMsg = this.accAuxInService.getAuxInStatus(this.request.getSession().getId());
        JSONArray auxInStatus = (JSONArray)resultMsg.getData();
        if (Objects.nonNull(auxInStatus) && auxInStatus.size() > 0) {
            auxInStatus.stream().forEach(auxIn -> {
                boolean bl = data.add(auxIn);
            });
        }
        return data;
    }

    public List getAllAuxOut() {
        ArrayList data = new ArrayList();
        ZKResultMsg resultMsg = this.accAuxOutService.getAuxOutStatus(this.request.getSession().getId());
        JSONArray auxOutStatus = (JSONArray)resultMsg.getData();
        if (Objects.nonNull(auxOutStatus) && auxOutStatus.size() > 0) {
            auxOutStatus.stream().forEach(auxOut -> {
                boolean bl = data.add(auxOut);
            });
        }
        return data;
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_eventNo_8", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:openDoor"})
    public ZKResultMsg openDoor(String ids, String openInterval) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("openDoor", openInterval, ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"acc:rtMonitor:closeDoor"})
    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_eventNo_9", requestParams={"name"}, opContent="acc_door_name")
    public ZKResultMsg closeDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("closeDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_eventNo_7", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:cancelAlarm", "acc:door:cancelAlarm"})
    public ZKResultMsg cancelAlarm(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("cancelAlarm", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_newEventNo_233", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:lockDoor"})
    public ZKResultMsg lockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("lockDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_newEventNo_234", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:unLockDoor"})
    public ZKResultMsg unLockDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("unLockDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_rtMonitor_remoteNormalOpen", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:normalOpenDoor"})
    public ZKResultMsg normalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("normalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg getAreasByUser() {
        Map areaMap = this.accRTMonitorService.getFilterAreaMap(this.request.getSession().getId());
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (areaMap.size() > 0) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("areaId", areaMap.get("areaIds"));
            dataJson.put("areaName", areaMap.get("areaName"));
            resultMsg.setData((Object)dataJson);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_eventNo_11", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:enableNormalOpenDoor"})
    public ZKResultMsg enableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("enableNormalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_eventNo_10", requestParams={"name"}, opContent="acc_door_name")
    @RequiresPermissions(value={"acc:rtMonitor:disableNormalOpenDoor"})
    public ZKResultMsg disableNormalOpenDoor(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateDoor("disableNormalOpenDoor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_rtMonitor_remoteOpen", requestParams={"name"}, opContent="common_name")
    @RequiresPermissions(value={"acc:rtMonitor:openAuxOut"})
    public ZKResultMsg openAuxOut(String ids, String openInterval) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateAuxOut("openAuxOut", openInterval, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_rtMonitor_remoteClose", requestParams={"name"}, opContent="common_name")
    @RequiresPermissions(value={"acc:rtMonitor:closeAuxOut"})
    public ZKResultMsg closeAuxOut(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateAuxOut("closeAuxOut", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_rtMonitor", opType="acc_rtMonitor_remoteNormalOpen", requestParams={"name"}, opContent="common_name")
    @RequiresPermissions(value={"acc:rtMonitor:auxOutNormalOpen"})
    public ZKResultMsg auxOutNormalOpen(String ids) {
        this.checkUserPwd();
        Map dataMap = this.accRTMonitorService.operateAuxOut("auxOutNormalOpen", null, ids);
        return this.dealResultData(dataMap);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String doorName;
        int n;
        int n2;
        String[] stringArray;
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = String.valueOf(I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0])) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            stringArray = cmdIdData.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String cmdData = stringArray[n];
                String cmdId = cmdData.split("=")[0];
                String doorName2 = cmdData.split("=")[1];
                Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                } else {
                    Integer ret = Integer.valueOf((String)resultMap.get("result"));
                    if (Objects.isNull(ret)) {
                        msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    } else if (ret < 0) {
                        String failedInfo = I18nUtil.i18nCode((String)this.accBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                        msg = String.valueOf(msg) + doorName2 + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
                    }
                }
                ++n;
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            stringArray = dataMap.get("offline").split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                doorName = stringArray[n];
                msg = String.valueOf(msg) + doorName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
                ++n;
            }
        }
        if (!"".equals(dataMap.get("notSupport"))) {
            stringArray = dataMap.get("notSupport").split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                doorName = stringArray[n];
                msg = String.valueOf(msg) + doorName + "," + I18nUtil.i18nCode((String)"acc_dev_devNotSupportFunction", (Object[])new Object[0]) + ";";
                ++n;
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return resultMsg;
    }

    public ZKResultMsg isKeepAlive() {
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public Boolean isShowlcdRTMonitor() {
        return this.accRTMonitorService.isShowlcdRTMonitor();
    }

    public ModelAndView openLcdRTMonitor() {
        String areaNames = this.accRTMonitorService.getAreaNamesBySessionId(this.request.getSession().getId());
        this.request.setAttribute("areaNames", (Object)areaNames);
        return new ModelAndView("acc/rtMonitor/openAccLcdRTMonitor");
    }

    public ZKResultMsg getPersonInfo(String areaNames) {
        return this.accRTMonitorService.getPersonInfo(areaNames);
    }

    public void checkUserPwd() {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(this.request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
    }
}

