/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccPersonLevelByPersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLevelByPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLevelByPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonSelectLevelItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLevelByPersonController
extends ExportController
implements AccPersonLevelByPersonRemote {
    private Logger logger = LoggerFactory.getLogger(AccPersonLevelByPersonController.class);
    @Autowired
    private AccPersonLevelByPersonService accPersonLevelByPersonService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private PersPersonService persPersonService;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    @RequiresPermissions(value={"acc:personLevelByPerson"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLevelByPerson/accPersonLevelByPerson");
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:refresh"})
    public DxGrid list(AccPersonLevelByPersonItem codition) {
        Pager pager = this.accPersonLevelByPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:refresh"})
    public DxGrid getPersonLevel(AccPersonLevelItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accLevelService.getAccPersonLevelItemsByPage(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid getPersonSelectLevel(AccPersonSelectLevelItem codition) {
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        ArrayList<String> selectLevelIds = new ArrayList<String>(Arrays.asList(codition.getSelectId().split(",")));
        if (codition.getType().equals("noSelected")) {
            StringBuilder notInLevelId = new StringBuilder();
            notInLevelId.append(StringUtils.join(selectLevelIds, (String)","));
            if (StringUtils.isNotBlank((CharSequence)codition.getNotInId())) {
                notInLevelId.append(",").append(codition.getNotInId());
            }
            codition.setNotInId(notInLevelId.toString());
        } else if (codition.getType().equals("selected")) {
            codition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        codition.setFilterId(codition.getPersonId());
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accLevelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:addLevel"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByPerson", opType="common_level_addPersonLevel", requestParams={"personPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg addLevel(@RequestParam(value="personId") String personId, @RequestParam(value="levelIds") String levelIds) {
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
            String[] levelIdArray = levelIds.split(",");
            int i = 0;
            int total = levelIdArray.length;
            while (i < total) {
                boolean isSetToDev;
                this.accLevelService.addLevelByParamIds(personId, levelIdArray[i], "person");
                boolean bl = isSetToDev = this.accLevelService.getDoorCountByLevelId(levelIdArray[i]) > 0L;
                if (isSetToDev) {
                    this.accLevelService.setPersonLevelToDev(levelIdArray[i], personId);
                    this.accLevelService.issuedDownloadToDev("levelType", levelIdArray[i]);
                }
                this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                ++i;
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:delLevel"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByPerson", opType="common_level_delPersonLevel", requestParams={"personPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg delLevel(String personId, String levelIds) {
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(levelIds.split(",")));
            this.accLevelService.immeDelPersonLevel(levelIdList, personId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:setAccParams"})
    public ModelAndView setAccParam(String ids) {
        AccPersonItem tempAccPerson = null;
        String[] personIds = ids.split(",");
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("pins", (Object)this.request.getParameter("pins"));
        List tempList = null;
        if (personIds != null && personIds.length == 1) {
            tempAccPerson = this.accPersonService.getItemByPersonId(personIds[0]);
            this.request.setAttribute("tempAccPerson", (Object)tempAccPerson);
            if (tempAccPerson != null) {
                tempList = this.accLevelService.getLevelByPersonId(tempAccPerson.getId());
                this.request.setAttribute("tempList", (Object)tempList);
            } else {
                this.logger.error("per_person acc_person data not sync");
            }
        }
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("acc/personLevelByPerson/setAccPersonParam");
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccPersonLevelItem accPersonLevelItem = new AccPersonLevelItem();
        this.setConditionValue((BaseItem)accPersonLevelItem);
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            accPersonLevelItem.setAuthAreaIdIn(authAreaIds);
        }
        List accPersonLevelItemList = this.accPersonLevelByPersonService.getExportItemList(accPersonLevelItem, this.getBeginIndex(), this.getEndIndex());
        Map authAreaMap = this.accPersonLevelByPersonService.getAuthAreaByPersonLevel(accPersonLevelItemList);
        accPersonLevelItemList.stream().forEach(item -> item.setAuthAreaName((String)authAreaMap.get(item.getAuthAreaId())));
        this.excelExport(accPersonLevelItemList, AccPersonLevelItem.class);
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:export"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByPerson", opType="common_op_export", opContent="common_op_export")
    public void exportPersonLevel(HttpServletRequest request, HttpServletResponse response) {
        List accPersonLevelItemList;
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String personIds = request.getParameter("personIds");
        AccPersonLevelItem accPersonLevelItem = new AccPersonLevelItem();
        accPersonLevelItem.setPersonIdIn(personIds);
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            accPersonLevelItem.setAuthAreaIdIn(authAreaIds);
        }
        if (Objects.isNull(accPersonLevelItemList = this.accPersonLevelByPersonService.getExportItemList(accPersonLevelItem, this.getBeginIndex(), this.getEndIndex())) || accPersonLevelItemList.isEmpty()) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        String reportType = request.getParameter("reportType");
        String jsonColumn = request.getParameter("jsonColumn");
        String fileNamePrefix = request.getParameter("tableNameParam");
        List personIdList = StrUtil.strToList((String)personIds);
        try {
            try {
                boolean isMSIE;
                List exportPersonLevelItemList = null;
                String filePath = String.valueOf(ClassUtil.getRootPath()) + "/" + FileUtils.systemFilePath + "/" + "acc" + "/" + "tempPersonLevel" + "/";
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                JSONObject jsonData = JSONObject.parseObject((String)request.getParameter("jsonData"));
                Map authAreaMap = this.accPersonLevelByPersonService.getAuthAreaByPersonLevel(accPersonLevelItemList);
                Map personIdAndPinMap = this.persPersonService.getPinsByPersonIds((Collection)personIdList);
                for (String personId : personIdList) {
                    AccPersonLevelItem personLevelItem = new AccPersonLevelItem();
                    personLevelItem.setPersonId(personId);
                    exportPersonLevelItemList = this.accPersonLevelByPersonService.getExportItemList(personLevelItem, this.getBeginIndex(), this.getEndIndex());
                    if (!Objects.nonNull(exportPersonLevelItemList) || exportPersonLevelItemList.isEmpty()) continue;
                    exportPersonLevelItemList.stream().forEach(item -> item.setAuthAreaName((String)authAreaMap.get(item.getAuthAreaId())));
                    String fileName = String.valueOf((String)personIdAndPinMap.get(personId)) + "." + "xls";
                    ExcelUtil.generateExcel((List)exportPersonLevelItemList, AccPersonLevelItem.class, (String)jsonColumn, (String)fileName, (String)reportType, (String)filePath, null);
                }
                String agent = request.getHeader("User-Agent");
                boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
                if (isMSIE) {
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                    fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
                } else {
                    fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
                }
                if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                    fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                    fileNamePrefix = fileNamePrefix.replace("%2520", " ");
                }
                String tempPath = String.valueOf(filePath) + "/" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
                File excelFile = new File(filePath);
                File[] excelFiles = excelFile.listFiles();
                if (StringUtils.isNotBlank((CharSequence)request.getParameter("encryptPassword"))) {
                    ArrayList<File> files = new ArrayList<File>();
                    files.addAll(Arrays.asList(excelFiles));
                    FileUtil.fileEncryptZip((String)tempPath, files, (String)request.getParameter("encryptPassword"), (HttpServletRequest)request, (HttpServletResponse)response);
                } else {
                    response = FileUtil.downLoadFiles((String)tempPath, (File[])excelFiles, (HttpServletRequest)request, (HttpServletResponse)response);
                }
                response.flushBuffer();
                File zipTempFile = new File(tempPath);
                if (zipTempFile.exists()) {
                    zipTempFile.delete();
                }
                FileUtils.deleteDirectory((String)filePath);
            }
            catch (Exception e) {
                this.log.error(String.valueOf(fileNamePrefix) + " export error", (Throwable)e);
                response.setHeader("Content-Disposition", "");
                response.setContentType("application/json");
                throw new ZKBusinessException("common_report_exportFaild");
            }
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    @RequiresPermissions(value={"acc:personLevelByPerson:sync"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByPerson", opType="common_dev_synchronize", opContent="common_dev_synchronize", requestParams={"personPins"})
    public ZKResultMsg syncPersonLevel(String personIds) {
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
            return this.accPersonLevelByPersonService.syncPersonLevel(this.request.getSession().getId(), personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

