/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLevelByLevelRemote;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLevelByLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonForLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLevelByLevelExportItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLevelByLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonListItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLevelByLevelController
extends ExportController
implements AccPersonLevelByLevelRemote {
    @Autowired
    private AccPersonLevelByLevelService accPersonLevelByLevelService;
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private ProgressCache progressCache;
    private Logger logger = LoggerFactory.getLogger(AccPersonLevelByLevelController.class);

    @RequiresPermissions(value={"acc:personLevelByLevel"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLevelByLevel/accPersonLevelByLevel");
    }

    @RequiresPermissions(value={"acc:personLevelByLevel:refresh"})
    public DxGrid list(AccPersonLevelByLevelItem codition) {
        Pager pager = this.accPersonLevelByLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByLevel:refresh"})
    public DxGrid getLevelPerson(AccPersonForLevelItem condition) {
        Pager pager = this.accPersonService.getLevelPersonItemsByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByLevel:addPerson"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_addPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String levelId, String personIds, String deptIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.accPersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)levelId)) {
            try {
                List personArrayIds = this.accPersonService.splitPersonIds(personIds, 500);
                boolean isSetToDev = this.accLevelService.getDoorCountByLevelId(levelId) > 0L;
                int[] currentCount = new int[1];
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.accLevelService.addLevelByParamIds(personArrayId, levelId, "person");
                    if (isSetToDev) {
                        this.accLevelService.setPersonLevelToDev(levelId, personArrayId);
                    }
                    nArray[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error("addPerson with level error", (Throwable)e);
            }
            this.accLevelService.issuedDownloadToDev("levelType", levelId);
        }
        this.progressCache.finishProcess(String.valueOf(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0])) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLevelByLevel:delPerson"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_delPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String levelId, String personIds) {
        ZKResultMsg zkResultMsg = this.accPersonLevelByLevelService.delPerson(levelId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"acc:personLevelByLevel:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccPersonListItem accPersonListItem = new AccPersonListItem();
        this.setConditionValue((BaseItem)accPersonListItem);
        List accPersonListItemList = this.accPersonLevelByLevelService.getExportItemList(request.getSession().getId(), accPersonListItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accPersonListItemList, AccPersonListItem.class);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByLevel", opType="acc_level_exportLevelPerson", opContent="acc_level_exportLevelPerson")
    @RequiresPermissions(value={"acc:personLevelByLevel:export"})
    public void exportLevelPerson(HttpServletRequest request, HttpServletResponse response) {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.accLevelService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String levelIds = request.getParameter("levelIds");
        AccPersonLevelByLevelExportItem accLevelPersonItem = new AccPersonLevelByLevelExportItem();
        accLevelPersonItem.setLevelIdsIn(levelIds);
        List accLevelPersonItemList = this.accPersonService.getExportLevelPersonItemListByAuthFilter(accLevelPersonItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(accLevelPersonItemList, AccPersonLevelByLevelExportItem.class);
    }

    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByLevel", opType="acc_level_importLevelPerson", opContent="acc_level_importLevelPerson")
    @RequiresPermissions(value={"acc:personLevelByLevel:import"})
    public ZKResultMsg importLevelPerson(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AccPersonLevelByLevelExportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.accLevelService.importAccPersonData(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

