/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLevelByDeptRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLevelByDeptService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeptLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeptSelectLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLevelByDeptItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLevelByDeptController
extends BaseController
implements AccPersonLevelByDeptRemote {
    private Logger logger = LoggerFactory.getLogger(AccPersonLevelByDeptController.class);
    @Autowired
    private AccPersonLevelByDeptService accPersonLevelByDeptService;
    @Autowired
    private AccPersonService accPersonService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"acc:personLevelByDept"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLevelByDept/accPersonLevelByDept");
    }

    @RequiresPermissions(value={"acc:personLevelByDept:refresh"})
    public DxGrid list(AccPersonLevelByDeptItem codition) {
        Pager pager = this.accPersonLevelByDeptService.getPagerFilterAuth(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByDept:refresh"})
    public DxGrid getDeptLevel(AccDeptLevelItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accLevelService.getDeptLevel(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByDept:addLevel"})
    public DxGrid getDeptSelectLevel(AccDeptSelectLevelItem codition) {
        String deptId = codition.getDeptId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        ArrayList<String> selectLevelIds = new ArrayList<String>(Arrays.asList(codition.getSelectId().split(",")));
        if (codition.getType().equals("noSelected")) {
            codition.setNotInId(StringUtils.join(selectLevelIds, (String)","));
        } else if (codition.getType().equals("selected")) {
            codition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        codition.setFilterId(deptId);
        Pager pager = this.accLevelService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLevelByDept:addLevel"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByDept", opType="common_level_addPersonLevel", requestParams={"deptCode", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg addLevel(String deptId, String levelIds, String immeUpdate) {
        if (StringUtils.isNotBlank((CharSequence)deptId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            try {
                this.accPersonLevelByDeptService.setDeptLinkLevel(deptId, levelIds);
                if ("true".equals(immeUpdate)) {
                    String personIds = this.accPersonService.getPersonIdsByDeptIds(deptId);
                    if (StringUtils.isNotBlank((CharSequence)personIds)) {
                        String clientId = this.request.getParameter("clientId");
                        this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
                        List personArrayIds = this.accPersonService.splitPersonIds(personIds, 500);
                        int[] currentCount = new int[1];
                        int[] totalCount = new int[]{personArrayIds.size()};
                        personArrayIds.parallelStream().forEach(personArrayId -> {
                            this.accLevelService.addPersonLevel(levelIds, personArrayId);
                            nArray[0] = currentCount[0] + 1;
                            this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                        });
                        this.accLevelService.issuedDownloadToDev("levelType", levelIds);
                    }
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("addPerson with level error", (Throwable)e);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:personLevelByDept:delLevel"})
    @LogRequest(module="acc_module", object="common_leftMenu_levelSetByDept", opType="common_level_delPersonLevel", requestParams={"deptCode", "levelName"}, opContent="common_level_name")
    public ZKResultMsg delLevel(String leftIds, String rightIds, String immeUpdate) {
        if (StringUtils.isNotBlank((CharSequence)leftIds) && StringUtils.isNotBlank((CharSequence)rightIds)) {
            this.accPersonLevelByDeptService.delLevel(leftIds, rightIds);
            if ("true".equals(immeUpdate)) {
                try {
                    this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
                    ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(rightIds.split(",")));
                    String personIds = this.accPersonService.getPersonIdsByDeptIds(leftIds);
                    List personArrayIds = this.accPersonService.splitPersonIds(personIds, 500);
                    int i = 0;
                    int total = personArrayIds.size();
                    while (i < total) {
                        this.accLevelService.immeDelPersonLevel(levelIdList, (String)personArrayIds.get(i));
                        personArrayIds.set(i, null);
                        Thread.sleep(1000L);
                        this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                        ++i;
                    }
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.logger.error("deletePerson with level error", (Throwable)e);
                }
            } else {
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getLevelListByDept(@RequestParam(value="deptId") String deptId) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.accPersonLevelByDeptService.getLevelListByDept(deptId)));
    }
}

